/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SnsActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to publish to an Amazon SNS topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SnsAction implements StructuredPojo, ToCopyableBuilder<SnsAction.Builder, SnsAction> {
    private final String targetArn;

    private final String roleArn;

    private final String messageFormat;

    private SnsAction(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.messageFormat = builder.messageFormat;
    }

    /**
     * <p>
     * The ARN of the SNS topic.
     * </p>
     * 
     * @return The ARN of the SNS topic.
     */
    public String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default value
     * of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant
     * platform-specific bits of the payload should be extracted. To read more about SNS message formats, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html"
     * >http://docs.aws.amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.
     * </p>
     * 
     * @return The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default
     *         value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and
     *         relevant platform-specific bits of the payload should be extracted. To read more about SNS message
     *         formats, see <a
     *         href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws.amazon.com
     *         /sns/latest/dg/json-formats.html</a> refer to their official documentation.
     * @see MessageFormat
     */
    public String messageFormat() {
        return messageFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((targetArn() == null) ? 0 : targetArn().hashCode());
        hashCode = 31 * hashCode + ((roleArn() == null) ? 0 : roleArn().hashCode());
        hashCode = 31 * hashCode + ((messageFormat() == null) ? 0 : messageFormat().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnsAction)) {
            return false;
        }
        SnsAction other = (SnsAction) obj;
        if (other.targetArn() == null ^ this.targetArn() == null) {
            return false;
        }
        if (other.targetArn() != null && !other.targetArn().equals(this.targetArn())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.messageFormat() == null ^ this.messageFormat() == null) {
            return false;
        }
        if (other.messageFormat() != null && !other.messageFormat().equals(this.messageFormat())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (targetArn() != null) {
            sb.append("TargetArn: ").append(targetArn()).append(",");
        }
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (messageFormat() != null) {
            sb.append("MessageFormat: ").append(messageFormat()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnsActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SnsAction> {
        /**
         * <p>
         * The ARN of the SNS topic.
         * </p>
         * 
         * @param targetArn
         *        The ARN of the SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The ARN of the IAM role that grants access.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default
         * value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and
         * relevant platform-specific bits of the payload should be extracted. To read more about SNS message formats,
         * see <a
         * href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws.amazon.com/sns/latest
         * /dg/json-formats.html</a> refer to their official documentation.
         * </p>
         * 
         * @param messageFormat
         *        The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The
         *        default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be
         *        parsed and relevant platform-specific bits of the payload should be extracted. To read more about SNS
         *        message formats, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws
         *        .amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormat
         */
        Builder messageFormat(String messageFormat);

        /**
         * <p>
         * The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default
         * value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and
         * relevant platform-specific bits of the payload should be extracted. To read more about SNS message formats,
         * see <a
         * href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws.amazon.com/sns/latest
         * /dg/json-formats.html</a> refer to their official documentation.
         * </p>
         * 
         * @param messageFormat
         *        The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The
         *        default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be
         *        parsed and relevant platform-specific bits of the payload should be extracted. To read more about SNS
         *        message formats, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws
         *        .amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormat
         */
        Builder messageFormat(MessageFormat messageFormat);
    }

    private static final class BuilderImpl implements Builder {
        private String targetArn;

        private String roleArn;

        private String messageFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(SnsAction model) {
            setTargetArn(model.targetArn);
            setRoleArn(model.roleArn);
            setMessageFormat(model.messageFormat);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getMessageFormat() {
            return messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormat messageFormat) {
            this.messageFormat(messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final void setMessageFormat(MessageFormat messageFormat) {
            this.messageFormat(messageFormat.toString());
        }

        @Override
        public SnsAction build() {
            return new SnsAction(this);
        }
    }
}
