/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iot.transform.ThingTypeMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value
 * indicating whether the thing type is deprecated, and a date and time when time was deprecated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ThingTypeMetadata implements StructuredPojo, ToCopyableBuilder<ThingTypeMetadata.Builder, ThingTypeMetadata> {
    private final Boolean deprecated;

    private final Date deprecationDate;

    private final Date creationDate;

    private ThingTypeMetadata(BuilderImpl builder) {
        this.deprecated = builder.deprecated;
        this.deprecationDate = builder.deprecationDate;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this type.
     * </p>
     * 
     * @return Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this type.
     */
    public Boolean deprecated() {
        return deprecated;
    }

    /**
     * <p>
     * The date and time when the thing type was deprecated.
     * </p>
     * 
     * @return The date and time when the thing type was deprecated.
     */
    public Date deprecationDate() {
        return deprecationDate;
    }

    /**
     * <p>
     * The date and time when the thing type was created.
     * </p>
     * 
     * @return The date and time when the thing type was created.
     */
    public Date creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deprecated() == null) ? 0 : deprecated().hashCode());
        hashCode = 31 * hashCode + ((deprecationDate() == null) ? 0 : deprecationDate().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeMetadata)) {
            return false;
        }
        ThingTypeMetadata other = (ThingTypeMetadata) obj;
        if (other.deprecated() == null ^ this.deprecated() == null) {
            return false;
        }
        if (other.deprecated() != null && !other.deprecated().equals(this.deprecated())) {
            return false;
        }
        if (other.deprecationDate() == null ^ this.deprecationDate() == null) {
            return false;
        }
        if (other.deprecationDate() != null && !other.deprecationDate().equals(this.deprecationDate())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deprecated() != null) {
            sb.append("Deprecated: ").append(deprecated()).append(",");
        }
        if (deprecationDate() != null) {
            sb.append("DeprecationDate: ").append(deprecationDate()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingTypeMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ThingTypeMetadata> {
        /**
         * <p>
         * Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this type.
         * </p>
         * 
         * @param deprecated
         *        Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecated(Boolean deprecated);

        /**
         * <p>
         * The date and time when the thing type was deprecated.
         * </p>
         * 
         * @param deprecationDate
         *        The date and time when the thing type was deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationDate(Date deprecationDate);

        /**
         * <p>
         * The date and time when the thing type was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the thing type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Date creationDate);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean deprecated;

        private Date deprecationDate;

        private Date creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeMetadata model) {
            setDeprecated(model.deprecated);
            setDeprecationDate(model.deprecationDate);
            setCreationDate(model.creationDate);
        }

        public final Boolean getDeprecated() {
            return deprecated;
        }

        @Override
        public final Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public final void setDeprecated(Boolean deprecated) {
            this.deprecated = deprecated;
        }

        public final Date getDeprecationDate() {
            return deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Date deprecationDate) {
            this.deprecationDate = StandardMemberCopier.copy(deprecationDate);
            return this;
        }

        public final void setDeprecationDate(Date deprecationDate) {
            this.deprecationDate = StandardMemberCopier.copy(deprecationDate);
        }

        public final Date getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
            return this;
        }

        public final void setCreationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
        }

        @Override
        public ThingTypeMetadata build() {
            return new ThingTypeMetadata(this);
        }
    }
}
