/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iot.transform.TopicRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TopicRule implements StructuredPojo, ToCopyableBuilder<TopicRule.Builder, TopicRule> {
    private final String ruleName;

    private final String sql;

    private final String description;

    private final Date createdAt;

    private final List<Action> actions;

    private final Boolean ruleDisabled;

    private final String awsIotSqlVersion;

    private TopicRule(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.sql = builder.sql;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.actions = builder.actions;
        this.ruleDisabled = builder.ruleDisabled;
        this.awsIotSqlVersion = builder.awsIotSqlVersion;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape the
     * newline characters.
     * </p>
     * 
     * @return The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape
     *         the newline characters.
     */
    public String sql() {
        return sql;
    }

    /**
     * <p>
     * The description of the rule.
     * </p>
     * 
     * @return The description of the rule.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date and time the rule was created.
     * </p>
     * 
     * @return The date and time the rule was created.
     */
    public Date createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The actions associated with the rule.
     * </p>
     * 
     * @return The actions associated with the rule.
     */
    public List<Action> actions() {
        return actions;
    }

    /**
     * <p>
     * Specifies whether the rule is disabled.
     * </p>
     * 
     * @return Specifies whether the rule is disabled.
     */
    public Boolean ruleDisabled() {
        return ruleDisabled;
    }

    /**
     * <p>
     * The version of the SQL rules engine to use when evaluating the rule.
     * </p>
     * 
     * @return The version of the SQL rules engine to use when evaluating the rule.
     */
    public String awsIotSqlVersion() {
        return awsIotSqlVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ruleName() == null) ? 0 : ruleName().hashCode());
        hashCode = 31 * hashCode + ((sql() == null) ? 0 : sql().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((actions() == null) ? 0 : actions().hashCode());
        hashCode = 31 * hashCode + ((ruleDisabled() == null) ? 0 : ruleDisabled().hashCode());
        hashCode = 31 * hashCode + ((awsIotSqlVersion() == null) ? 0 : awsIotSqlVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRule)) {
            return false;
        }
        TopicRule other = (TopicRule) obj;
        if (other.ruleName() == null ^ this.ruleName() == null) {
            return false;
        }
        if (other.ruleName() != null && !other.ruleName().equals(this.ruleName())) {
            return false;
        }
        if (other.sql() == null ^ this.sql() == null) {
            return false;
        }
        if (other.sql() != null && !other.sql().equals(this.sql())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.actions() == null ^ this.actions() == null) {
            return false;
        }
        if (other.actions() != null && !other.actions().equals(this.actions())) {
            return false;
        }
        if (other.ruleDisabled() == null ^ this.ruleDisabled() == null) {
            return false;
        }
        if (other.ruleDisabled() != null && !other.ruleDisabled().equals(this.ruleDisabled())) {
            return false;
        }
        if (other.awsIotSqlVersion() == null ^ this.awsIotSqlVersion() == null) {
            return false;
        }
        if (other.awsIotSqlVersion() != null && !other.awsIotSqlVersion().equals(this.awsIotSqlVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ruleName() != null) {
            sb.append("RuleName: ").append(ruleName()).append(",");
        }
        if (sql() != null) {
            sb.append("Sql: ").append(sql()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (actions() != null) {
            sb.append("Actions: ").append(actions()).append(",");
        }
        if (ruleDisabled() != null) {
            sb.append("RuleDisabled: ").append(ruleDisabled()).append(",");
        }
        if (awsIotSqlVersion() != null) {
            sb.append("AwsIotSqlVersion: ").append(awsIotSqlVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TopicRule> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape the
         * newline characters.
         * </p>
         * 
         * @param sql
         *        The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to
         *        escape the newline characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sql(String sql);

        /**
         * <p>
         * The description of the rule.
         * </p>
         * 
         * @param description
         *        The description of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time the rule was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Date createdAt);

        /**
         * <p>
         * The actions associated with the rule.
         * </p>
         * 
         * @param actions
         *        The actions associated with the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions associated with the rule.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setActions(java.util.Collection)} or {@link #withActions(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param actions
         *        The actions associated with the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * Specifies whether the rule is disabled.
         * </p>
         * 
         * @param ruleDisabled
         *        Specifies whether the rule is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDisabled(Boolean ruleDisabled);

        /**
         * <p>
         * The version of the SQL rules engine to use when evaluating the rule.
         * </p>
         * 
         * @param awsIotSqlVersion
         *        The version of the SQL rules engine to use when evaluating the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotSqlVersion(String awsIotSqlVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String ruleName;

        private String sql;

        private String description;

        private Date createdAt;

        private List<Action> actions;

        private Boolean ruleDisabled;

        private String awsIotSqlVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRule model) {
            setRuleName(model.ruleName);
            setSql(model.sql);
            setDescription(model.description);
            setCreatedAt(model.createdAt);
            setActions(model.actions);
            setRuleDisabled(model.ruleDisabled);
            setAwsIotSqlVersion(model.awsIotSqlVersion);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getSql() {
            return sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Date getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy(createdAt);
            return this;
        }

        public final void setCreatedAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy(createdAt);
        }

        public final Collection<Action> getActions() {
            return actions;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            if (this.actions == null) {
                this.actions = new ArrayList<>(actions.length);
            }
            for (Action e : actions) {
                this.actions.add(e);
            }
            return this;
        }

        public final void setActions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
        }

        @SafeVarargs
        public final void setActions(Action... actions) {
            if (this.actions == null) {
                this.actions = new ArrayList<>(actions.length);
            }
            for (Action e : actions) {
                this.actions.add(e);
            }
        }

        public final Boolean getRuleDisabled() {
            return ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        public final String getAwsIotSqlVersion() {
            return awsIotSqlVersion;
        }

        @Override
        public final Builder awsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
            return this;
        }

        public final void setAwsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
        }

        @Override
        public TopicRule build() {
            return new TopicRule(this);
        }
    }
}
