/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the UpdateThingShadow operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateThingShadowRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateThingShadowRequest.Builder, UpdateThingShadowRequest> {
    private final String thingName;

    private final ByteBuffer payload;

    private UpdateThingShadowRequest(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The name of the thing.
     * </p>
     * 
     * @return The name of the thing.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The state information, in JSON format.
     * </p>
     * <p>
     * {@code ByteBuffer}s are stateful. Calling their {@code get} methods changes their {@code position}. We recommend
     * using {@link java.nio.ByteBuffer#asReadOnlyBuffer()} to create a read-only view of the buffer with an independent
     * {@code position}, and calling {@code get} methods on this rather than directly on the returned {@code ByteBuffer}
     * . Doing so will ensure that anyone else using the {@code ByteBuffer} will not be affected by changes to the
     * {@code position}.
     * </p>
     * 
     * @return The state information, in JSON format.
     */
    public ByteBuffer payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((thingName() == null) ? 0 : thingName().hashCode());
        hashCode = 31 * hashCode + ((payload() == null) ? 0 : payload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingShadowRequest)) {
            return false;
        }
        UpdateThingShadowRequest other = (UpdateThingShadowRequest) obj;
        if (other.thingName() == null ^ this.thingName() == null) {
            return false;
        }
        if (other.thingName() != null && !other.thingName().equals(this.thingName())) {
            return false;
        }
        if (other.payload() == null ^ this.payload() == null) {
            return false;
        }
        if (other.payload() != null && !other.payload().equals(this.payload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (thingName() != null) {
            sb.append("ThingName: ").append(thingName()).append(",");
        }
        if (payload() != null) {
            sb.append("Payload: ").append(payload()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateThingShadowRequest> {
        /**
         * <p>
         * The name of the thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The state information, in JSON format.
         * </p>
         * 
         * @param payload
         *        The state information, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(ByteBuffer payload);
    }

    private static final class BuilderImpl implements Builder {
        private String thingName;

        private ByteBuffer payload;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingShadowRequest model) {
            setThingName(model.thingName);
            setPayload(model.payload);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final ByteBuffer getPayload() {
            return payload;
        }

        @Override
        public final Builder payload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy(payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy(payload);
        }

        @Override
        public UpdateThingShadowRequest build() {
            return new UpdateThingShadowRequest(this);
        }
    }
}
