/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.PoliciesCopier;
import software.amazon.awssdk.services.iot.model.Policy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPoliciesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPoliciesResponse> {
    private final List<Policy> policies;
    private final String nextMarker;

    private ListPoliciesResponse(BuilderImpl builder) {
        this.policies = builder.policies;
        this.nextMarker = builder.nextMarker;
    }

    public List<Policy> policies() {
        return this.policies;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policies() == null ? 0 : this.policies().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesResponse)) {
            return false;
        }
        ListPoliciesResponse other = (ListPoliciesResponse)((Object)obj);
        if (other.policies() == null ^ this.policies() == null) {
            return false;
        }
        if (other.policies() != null && !other.policies().equals(this.policies())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policies() != null) {
            sb.append("Policies: ").append(this.policies()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Policy> policies;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesResponse model) {
            this.setPolicies(model.policies);
            this.setNextMarker(model.nextMarker);
        }

        public final Collection<Policy> getPolicies() {
            return this.policies;
        }

        @Override
        public final Builder policies(Collection<Policy> policies) {
            this.policies = PoliciesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Policy ... policies) {
            if (this.policies == null) {
                this.policies = new ArrayList<Policy>(policies.length);
            }
            for (Policy e : policies) {
                this.policies.add(e);
            }
            return this;
        }

        public final void setPolicies(Collection<Policy> policies) {
            this.policies = PoliciesCopier.copy(policies);
        }

        @SafeVarargs
        public final void setPolicies(Policy ... policies) {
            if (this.policies == null) {
                this.policies = new ArrayList<Policy>(policies.length);
            }
            for (Policy e : policies) {
                this.policies.add(e);
            }
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public ListPoliciesResponse build() {
            return new ListPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPoliciesResponse> {
        public Builder policies(Collection<Policy> var1);

        public Builder policies(Policy ... var1);

        public Builder nextMarker(String var1);
    }
}

