/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RejectCertificateTransferRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RejectCertificateTransferRequest> {
    private final String certificateId;
    private final String rejectReason;

    private RejectCertificateTransferRequest(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.rejectReason = builder.rejectReason;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String rejectReason() {
        return this.rejectReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateId() == null ? 0 : this.certificateId().hashCode());
        hashCode = 31 * hashCode + (this.rejectReason() == null ? 0 : this.rejectReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectCertificateTransferRequest)) {
            return false;
        }
        RejectCertificateTransferRequest other = (RejectCertificateTransferRequest)((Object)obj);
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.rejectReason() == null ^ this.rejectReason() == null) {
            return false;
        }
        return other.rejectReason() == null || other.rejectReason().equals(this.rejectReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateId() != null) {
            sb.append("CertificateId: ").append(this.certificateId()).append(",");
        }
        if (this.rejectReason() != null) {
            sb.append("RejectReason: ").append(this.rejectReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String certificateId;
        private String rejectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectCertificateTransferRequest model) {
            this.setCertificateId(model.certificateId);
            this.setRejectReason(model.rejectReason);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getRejectReason() {
            return this.rejectReason;
        }

        @Override
        public final Builder rejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
            return this;
        }

        public final void setRejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
        }

        public RejectCertificateTransferRequest build() {
            return new RejectCertificateTransferRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RejectCertificateTransferRequest> {
        public Builder certificateId(String var1);

        public Builder rejectReason(String var1);
    }
}

