/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CannedAccessControlList;
import software.amazon.awssdk.services.iot.transform.S3ActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3Action
implements StructuredPojo,
ToCopyableBuilder<Builder, S3Action> {
    private final String roleArn;
    private final String bucketName;
    private final String key;
    private final String cannedAcl;

    private S3Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.bucketName = builder.bucketName;
        this.key = builder.key;
        this.cannedAcl = builder.cannedAcl;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String key() {
        return this.key;
    }

    public String cannedAcl() {
        return this.cannedAcl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.bucketName() == null ? 0 : this.bucketName().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.cannedAcl() == null ? 0 : this.cannedAcl().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action)obj;
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.bucketName() == null ^ this.bucketName() == null) {
            return false;
        }
        if (other.bucketName() != null && !other.bucketName().equals(this.bucketName())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.cannedAcl() == null ^ this.cannedAcl() == null) {
            return false;
        }
        return other.cannedAcl() == null || other.cannedAcl().equals(this.cannedAcl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.bucketName() != null) {
            sb.append("BucketName: ").append(this.bucketName()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.cannedAcl() != null) {
            sb.append("CannedAcl: ").append(this.cannedAcl()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String bucketName;
        private String key;
        private String cannedAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Action model) {
            this.setRoleArn(model.roleArn);
            this.setBucketName(model.bucketName);
            this.setKey(model.key);
            this.setCannedAcl(model.cannedAcl);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getCannedAcl() {
            return this.cannedAcl;
        }

        @Override
        public final Builder cannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
            return this;
        }

        @Override
        public final Builder cannedAcl(CannedAccessControlList cannedAcl) {
            this.cannedAcl(cannedAcl.toString());
            return this;
        }

        public final void setCannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
        }

        public final void setCannedAcl(CannedAccessControlList cannedAcl) {
            this.cannedAcl(cannedAcl.toString());
        }

        public S3Action build() {
            return new S3Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Action> {
        public Builder roleArn(String var1);

        public Builder bucketName(String var1);

        public Builder key(String var1);

        public Builder cannedAcl(String var1);

        public Builder cannedAcl(CannedAccessControlList var1);
    }
}

