/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.MessageFormat;
import software.amazon.awssdk.services.iot.transform.SnsActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SnsAction
implements StructuredPojo,
ToCopyableBuilder<Builder, SnsAction> {
    private final String targetArn;
    private final String roleArn;
    private final String messageFormat;

    private SnsAction(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.messageFormat = builder.messageFormat;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String messageFormat() {
        return this.messageFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetArn() == null ? 0 : this.targetArn().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.messageFormat() == null ? 0 : this.messageFormat().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnsAction)) {
            return false;
        }
        SnsAction other = (SnsAction)obj;
        if (other.targetArn() == null ^ this.targetArn() == null) {
            return false;
        }
        if (other.targetArn() != null && !other.targetArn().equals(this.targetArn())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.messageFormat() == null ^ this.messageFormat() == null) {
            return false;
        }
        return other.messageFormat() == null || other.messageFormat().equals(this.messageFormat());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.targetArn() != null) {
            sb.append("TargetArn: ").append(this.targetArn()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.messageFormat() != null) {
            sb.append("MessageFormat: ").append(this.messageFormat()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnsActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String targetArn;
        private String roleArn;
        private String messageFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(SnsAction model) {
            this.setTargetArn(model.targetArn);
            this.setRoleArn(model.roleArn);
            this.setMessageFormat(model.messageFormat);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormat messageFormat) {
            this.messageFormat(messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final void setMessageFormat(MessageFormat messageFormat) {
            this.messageFormat(messageFormat.toString());
        }

        public SnsAction build() {
            return new SnsAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SnsAction> {
        public Builder targetArn(String var1);

        public Builder roleArn(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormat var1);
    }
}

