/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iot.transform.ThingTypeMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ThingTypeMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, ThingTypeMetadata> {
    private final Boolean deprecated;
    private final Date deprecationDate;
    private final Date creationDate;

    private ThingTypeMetadata(BuilderImpl builder) {
        this.deprecated = builder.deprecated;
        this.deprecationDate = builder.deprecationDate;
        this.creationDate = builder.creationDate;
    }

    public Boolean deprecated() {
        return this.deprecated;
    }

    public Date deprecationDate() {
        return this.deprecationDate;
    }

    public Date creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deprecated() == null ? 0 : this.deprecated().hashCode());
        hashCode = 31 * hashCode + (this.deprecationDate() == null ? 0 : this.deprecationDate().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeMetadata)) {
            return false;
        }
        ThingTypeMetadata other = (ThingTypeMetadata)obj;
        if (other.deprecated() == null ^ this.deprecated() == null) {
            return false;
        }
        if (other.deprecated() != null && !other.deprecated().equals(this.deprecated())) {
            return false;
        }
        if (other.deprecationDate() == null ^ this.deprecationDate() == null) {
            return false;
        }
        if (other.deprecationDate() != null && !other.deprecationDate().equals(this.deprecationDate())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        return other.creationDate() == null || other.creationDate().equals(this.creationDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deprecated() != null) {
            sb.append("Deprecated: ").append(this.deprecated()).append(",");
        }
        if (this.deprecationDate() != null) {
            sb.append("DeprecationDate: ").append(this.deprecationDate()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingTypeMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean deprecated;
        private Date deprecationDate;
        private Date creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeMetadata model) {
            this.setDeprecated(model.deprecated);
            this.setDeprecationDate(model.deprecationDate);
            this.setCreationDate(model.creationDate);
        }

        public final Boolean getDeprecated() {
            return this.deprecated;
        }

        @Override
        public final Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public final void setDeprecated(Boolean deprecated) {
            this.deprecated = deprecated;
        }

        public final Date getDeprecationDate() {
            return this.deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Date deprecationDate) {
            this.deprecationDate = StandardMemberCopier.copy((Date)deprecationDate);
            return this;
        }

        public final void setDeprecationDate(Date deprecationDate) {
            this.deprecationDate = StandardMemberCopier.copy((Date)deprecationDate);
        }

        public final Date getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy((Date)creationDate);
            return this;
        }

        public final void setCreationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy((Date)creationDate);
        }

        public ThingTypeMetadata build() {
            return new ThingTypeMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ThingTypeMetadata> {
        public Builder deprecated(Boolean var1);

        public Builder deprecationDate(Date var1);

        public Builder creationDate(Date var1);
    }
}

