/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.SqsAction;

@SdkInternalApi
public class SqsActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<String> QUEUEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("queueUrl").build();
    private static final MarshallingInfo<Boolean> USEBASE64_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("useBase64").build();
    private static final SqsActionMarshaller instance = new SqsActionMarshaller();

    public static SqsActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(SqsAction sqsAction, ProtocolMarshaller protocolMarshaller) {
        if (sqsAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sqsAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)sqsAction.queueUrl(), QUEUEURL_BINDING);
            protocolMarshaller.marshall((Object)sqsAction.useBase64(), USEBASE64_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

