/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CertificateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Certificate implements StructuredPojo, ToCopyableBuilder<Certificate.Builder, Certificate> {
    private final String certificateArn;

    private final String certificateId;

    private final String status;

    private final Instant creationDate;

    private Certificate(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The ARN of the certificate.
     * </p>
     * 
     * @return The ARN of the certificate.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The ID of the certificate.
     * </p>
     * 
     * @return The ID of the certificate.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The status of the certificate.
     * </p>
     * <p>
     * The status value REGISTER_INACTIVE is deprecated and should not be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the certificate.</p>
     *         <p>
     *         The status value REGISTER_INACTIVE is deprecated and should not be used.
     * @see CertificateStatus
     */
    public CertificateStatus status() {
        return CertificateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the certificate.
     * </p>
     * <p>
     * The status value REGISTER_INACTIVE is deprecated and should not be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the certificate.</p>
     *         <p>
     *         The status value REGISTER_INACTIVE is deprecated and should not be used.
     * @see CertificateStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time the certificate was created.
     * </p>
     * 
     * @return The date and time the certificate was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationDate(), other.creationDate());
    }

    @Override
    public String toString() {
        return ToString.builder("Certificate").add("CertificateArn", certificateArn()).add("CertificateId", certificateId())
                .add("Status", statusAsString()).add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.of(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.of(clazz.cast(certificateId()));
        case "status":
            return Optional.of(clazz.cast(statusAsString()));
        case "creationDate":
            return Optional.of(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Certificate> {
        /**
         * <p>
         * The ARN of the certificate.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The ID of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The status of the certificate.
         * </p>
         * <p>
         * The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param status
         *        The status of the certificate.</p>
         *        <p>
         *        The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the certificate.
         * </p>
         * <p>
         * The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param status
         *        The status of the certificate.</p>
         *        <p>
         *        The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(CertificateStatus status);

        /**
         * <p>
         * The date and time the certificate was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time the certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String status;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
            status(model.status);
            creationDate(model.creationDate);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public Certificate build() {
            return new Certificate(this);
        }
    }
}
