/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreateCertificateFromCsr operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCertificateFromCsrRequest extends IoTRequest implements
        ToCopyableBuilder<CreateCertificateFromCsrRequest.Builder, CreateCertificateFromCsrRequest> {
    private final String certificateSigningRequest;

    private final Boolean setAsActive;

    private CreateCertificateFromCsrRequest(BuilderImpl builder) {
        super(builder);
        this.certificateSigningRequest = builder.certificateSigningRequest;
        this.setAsActive = builder.setAsActive;
    }

    /**
     * <p>
     * The certificate signing request (CSR).
     * </p>
     * 
     * @return The certificate signing request (CSR).
     */
    public String certificateSigningRequest() {
        return certificateSigningRequest;
    }

    /**
     * <p>
     * Specifies whether the certificate is active.
     * </p>
     * 
     * @return Specifies whether the certificate is active.
     */
    public Boolean setAsActive() {
        return setAsActive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateSigningRequest());
        hashCode = 31 * hashCode + Objects.hashCode(setAsActive());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateFromCsrRequest)) {
            return false;
        }
        CreateCertificateFromCsrRequest other = (CreateCertificateFromCsrRequest) obj;
        return Objects.equals(certificateSigningRequest(), other.certificateSigningRequest())
                && Objects.equals(setAsActive(), other.setAsActive());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateCertificateFromCsrRequest").add("CertificateSigningRequest", certificateSigningRequest())
                .add("SetAsActive", setAsActive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateSigningRequest":
            return Optional.of(clazz.cast(certificateSigningRequest()));
        case "setAsActive":
            return Optional.of(clazz.cast(setAsActive()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTRequest.Builder, CopyableBuilder<Builder, CreateCertificateFromCsrRequest> {
        /**
         * <p>
         * The certificate signing request (CSR).
         * </p>
         * 
         * @param certificateSigningRequest
         *        The certificate signing request (CSR).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateSigningRequest(String certificateSigningRequest);

        /**
         * <p>
         * Specifies whether the certificate is active.
         * </p>
         * 
         * @param setAsActive
         *        Specifies whether the certificate is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setAsActive(Boolean setAsActive);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTRequest.BuilderImpl implements Builder {
        private String certificateSigningRequest;

        private Boolean setAsActive;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateFromCsrRequest model) {
            super(model);
            certificateSigningRequest(model.certificateSigningRequest);
            setAsActive(model.setAsActive);
        }

        public final String getCertificateSigningRequest() {
            return certificateSigningRequest;
        }

        @Override
        public final Builder certificateSigningRequest(String certificateSigningRequest) {
            this.certificateSigningRequest = certificateSigningRequest;
            return this;
        }

        public final void setCertificateSigningRequest(String certificateSigningRequest) {
            this.certificateSigningRequest = certificateSigningRequest;
        }

        public final Boolean getSetAsActive() {
            return setAsActive;
        }

        @Override
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateCertificateFromCsrRequest build() {
            return new CreateCertificateFromCsrRequest(this);
        }
    }
}
