/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the CreateThing operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateThingResponse extends IoTResponse implements
        ToCopyableBuilder<CreateThingResponse.Builder, CreateThingResponse> {
    private final String thingName;

    private final String thingArn;

    private CreateThingResponse(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingArn = builder.thingArn;
    }

    /**
     * <p>
     * The name of the new thing.
     * </p>
     * 
     * @return The name of the new thing.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The ARN of the new thing.
     * </p>
     * 
     * @return The ARN of the new thing.
     */
    public String thingArn() {
        return thingArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingResponse)) {
            return false;
        }
        CreateThingResponse other = (CreateThingResponse) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingArn(), other.thingArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateThingResponse").add("ThingName", thingName()).add("ThingArn", thingArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.of(clazz.cast(thingName()));
        case "thingArn":
            return Optional.of(clazz.cast(thingArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, CreateThingResponse> {
        /**
         * <p>
         * The name of the new thing.
         * </p>
         * 
         * @param thingName
         *        The name of the new thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The ARN of the new thing.
         * </p>
         * 
         * @param thingArn
         *        The ARN of the new thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private String thingName;

        private String thingArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingResponse model) {
            super(model);
            thingName(model.thingName);
            thingArn(model.thingArn);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingArn() {
            return thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        public CreateThingResponse build() {
            return new CreateThingResponse(this);
        }
    }
}
