/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the EnableTopicRuleRequest operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EnableTopicRuleRequest extends IoTRequest implements
        ToCopyableBuilder<EnableTopicRuleRequest.Builder, EnableTopicRuleRequest> {
    private final String ruleName;

    private EnableTopicRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
    }

    /**
     * <p>
     * The name of the topic rule to enable.
     * </p>
     * 
     * @return The name of the topic rule to enable.
     */
    public String ruleName() {
        return ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableTopicRuleRequest)) {
            return false;
        }
        EnableTopicRuleRequest other = (EnableTopicRuleRequest) obj;
        return Objects.equals(ruleName(), other.ruleName());
    }

    @Override
    public String toString() {
        return ToString.builder("EnableTopicRuleRequest").add("RuleName", ruleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleName":
            return Optional.of(clazz.cast(ruleName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTRequest.Builder, CopyableBuilder<Builder, EnableTopicRuleRequest> {
        /**
         * <p>
         * The name of the topic rule to enable.
         * </p>
         * 
         * @param ruleName
         *        The name of the topic rule to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTRequest.BuilderImpl implements Builder {
        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableTopicRuleRequest model) {
            super(model);
            ruleName(model.ruleName);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public EnableTopicRuleRequest build() {
            return new EnableTopicRuleRequest(this);
        }
    }
}
