/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the GetPolicyVersion operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetPolicyVersionResponse extends IoTResponse implements
        ToCopyableBuilder<GetPolicyVersionResponse.Builder, GetPolicyVersionResponse> {
    private final String policyArn;

    private final String policyName;

    private final String policyDocument;

    private final String policyVersionId;

    private final Boolean isDefaultVersion;

    private GetPolicyVersionResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.policyVersionId = builder.policyVersionId;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    /**
     * <p>
     * The policy ARN.
     * </p>
     * 
     * @return The policy ARN.
     */
    public String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The policy name.
     * </p>
     * 
     * @return The policy name.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The JSON document that describes the policy.
     * </p>
     * 
     * @return The JSON document that describes the policy.
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The policy version ID.
     * </p>
     * 
     * @return The policy version ID.
     */
    public String policyVersionId() {
        return policyVersionId;
    }

    /**
     * <p>
     * Specifies whether the policy version is the default.
     * </p>
     * 
     * @return Specifies whether the policy version is the default.
     */
    public Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyVersionResponse)) {
            return false;
        }
        GetPolicyVersionResponse other = (GetPolicyVersionResponse) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(policyName(), other.policyName())
                && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(policyVersionId(), other.policyVersionId())
                && Objects.equals(isDefaultVersion(), other.isDefaultVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("GetPolicyVersionResponse").add("PolicyArn", policyArn()).add("PolicyName", policyName())
                .add("PolicyDocument", policyDocument()).add("PolicyVersionId", policyVersionId())
                .add("IsDefaultVersion", isDefaultVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.of(clazz.cast(policyArn()));
        case "policyName":
            return Optional.of(clazz.cast(policyName()));
        case "policyDocument":
            return Optional.of(clazz.cast(policyDocument()));
        case "policyVersionId":
            return Optional.of(clazz.cast(policyVersionId()));
        case "isDefaultVersion":
            return Optional.of(clazz.cast(isDefaultVersion()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, GetPolicyVersionResponse> {
        /**
         * <p>
         * The policy ARN.
         * </p>
         * 
         * @param policyArn
         *        The policy ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The policy name.
         * </p>
         * 
         * @param policyName
         *        The policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The JSON document that describes the policy.
         * </p>
         * 
         * @param policyDocument
         *        The JSON document that describes the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The policy version ID.
         * </p>
         * 
         * @param policyVersionId
         *        The policy version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionId(String policyVersionId);

        /**
         * <p>
         * Specifies whether the policy version is the default.
         * </p>
         * 
         * @param isDefaultVersion
         *        Specifies whether the policy version is the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private String policyArn;

        private String policyName;

        private String policyDocument;

        private String policyVersionId;

        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyVersionResponse model) {
            super(model);
            policyArn(model.policyArn);
            policyName(model.policyName);
            policyDocument(model.policyDocument);
            policyVersionId(model.policyVersionId);
            isDefaultVersion(model.isDefaultVersion);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final String getPolicyVersionId() {
            return policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public GetPolicyVersionResponse build() {
            return new GetPolicyVersionResponse(this);
        }
    }
}
