/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the ListCertificatesByCA operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCertificatesByCAResponse extends IoTResponse implements
        ToCopyableBuilder<ListCertificatesByCAResponse.Builder, ListCertificatesByCAResponse> {
    private final List<Certificate> certificates;

    private final String nextMarker;

    private ListCertificatesByCAResponse(BuilderImpl builder) {
        super(builder);
        this.certificates = builder.certificates;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The device certificates signed by the specified CA certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The device certificates signed by the specified CA certificate.
     */
    public List<Certificate> certificates() {
        return certificates;
    }

    /**
     * <p>
     * The marker for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The marker for the next set of results, or null if there are no additional results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificates());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesByCAResponse)) {
            return false;
        }
        ListCertificatesByCAResponse other = (ListCertificatesByCAResponse) obj;
        return Objects.equals(certificates(), other.certificates()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("ListCertificatesByCAResponse").add("Certificates", certificates())
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificates":
            return Optional.of(clazz.cast(certificates()));
        case "nextMarker":
            return Optional.of(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, ListCertificatesByCAResponse> {
        /**
         * <p>
         * The device certificates signed by the specified CA certificate.
         * </p>
         * 
         * @param certificates
         *        The device certificates signed by the specified CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<Certificate> certificates);

        /**
         * <p>
         * The device certificates signed by the specified CA certificate.
         * </p>
         * 
         * @param certificates
         *        The device certificates signed by the specified CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Certificate... certificates);

        /**
         * <p>
         * The device certificates signed by the specified CA certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Certificate>.Builder} avoiding the need to
         * create one manually via {@link List<Certificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Certificate>.Builder#build()} is called immediately and its
         * result is passed to {@link #certificates(List<Certificate>)}.
         * 
         * @param certificates
         *        a consumer that will call methods on {@link List<Certificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificates(List<Certificate>)
         */
        Builder certificates(Consumer<Certificate.Builder>... certificates);

        /**
         * <p>
         * The marker for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextMarker
         *        The marker for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private List<Certificate> certificates;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesByCAResponse model) {
            super(model);
            certificates(model.certificates);
            nextMarker(model.nextMarker);
        }

        public final Collection<Certificate.Builder> getCertificates() {
            return certificates != null ? certificates.stream().map(Certificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<Certificate.Builder>... certificates) {
            certificates(Stream.of(certificates).map(c -> Certificate.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificatesCopier.copyFromBuilder(certificates);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListCertificatesByCAResponse build() {
            return new ListCertificatesByCAResponse(this);
        }
    }
}
