/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListPolicyVersions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListPolicyVersionsResponse extends IoTResponse implements
        ToCopyableBuilder<ListPolicyVersionsResponse.Builder, ListPolicyVersionsResponse> {
    private final List<PolicyVersion> policyVersions;

    private ListPolicyVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.policyVersions = builder.policyVersions;
    }

    /**
     * <p>
     * The policy versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The policy versions.
     */
    public List<PolicyVersion> policyVersions() {
        return policyVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsResponse)) {
            return false;
        }
        ListPolicyVersionsResponse other = (ListPolicyVersionsResponse) obj;
        return Objects.equals(policyVersions(), other.policyVersions());
    }

    @Override
    public String toString() {
        return ToString.builder("ListPolicyVersionsResponse").add("PolicyVersions", policyVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyVersions":
            return Optional.of(clazz.cast(policyVersions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, ListPolicyVersionsResponse> {
        /**
         * <p>
         * The policy versions.
         * </p>
         * 
         * @param policyVersions
         *        The policy versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersions(Collection<PolicyVersion> policyVersions);

        /**
         * <p>
         * The policy versions.
         * </p>
         * 
         * @param policyVersions
         *        The policy versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersions(PolicyVersion... policyVersions);

        /**
         * <p>
         * The policy versions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyVersion>.Builder} avoiding the need
         * to create one manually via {@link List<PolicyVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyVersion>.Builder#build()} is called immediately and
         * its result is passed to {@link #policyVersions(List<PolicyVersion>)}.
         * 
         * @param policyVersions
         *        a consumer that will call methods on {@link List<PolicyVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyVersions(List<PolicyVersion>)
         */
        Builder policyVersions(Consumer<PolicyVersion.Builder>... policyVersions);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private List<PolicyVersion> policyVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyVersionsResponse model) {
            super(model);
            policyVersions(model.policyVersions);
        }

        public final Collection<PolicyVersion.Builder> getPolicyVersions() {
            return policyVersions != null ? policyVersions.stream().map(PolicyVersion::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder policyVersions(Collection<PolicyVersion> policyVersions) {
            this.policyVersions = PolicyVersionsCopier.copy(policyVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersions(PolicyVersion... policyVersions) {
            policyVersions(Arrays.asList(policyVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersions(Consumer<PolicyVersion.Builder>... policyVersions) {
            policyVersions(Stream.of(policyVersions).map(c -> PolicyVersion.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyVersions(Collection<PolicyVersion.BuilderImpl> policyVersions) {
            this.policyVersions = PolicyVersionsCopier.copyFromBuilder(policyVersions);
        }

        @Override
        public ListPolicyVersionsResponse build() {
            return new ListPolicyVersionsResponse(this);
        }
    }
}
