/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListThings operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListThingsResponse extends IoTResponse implements ToCopyableBuilder<ListThingsResponse.Builder, ListThingsResponse> {
    private final List<ThingAttribute> things;

    private final String nextToken;

    private ListThingsResponse(BuilderImpl builder) {
        super(builder);
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The things.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The things.
     */
    public List<ThingAttribute> things() {
        return things;
    }

    /**
     * <p>
     * The token for the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(things());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingsResponse)) {
            return false;
        }
        ListThingsResponse other = (ListThingsResponse) obj;
        return Objects.equals(things(), other.things()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListThingsResponse").add("Things", things()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "things":
            return Optional.of(clazz.cast(things()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, ListThingsResponse> {
        /**
         * <p>
         * The things.
         * </p>
         * 
         * @param things
         *        The things.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(Collection<ThingAttribute> things);

        /**
         * <p>
         * The things.
         * </p>
         * 
         * @param things
         *        The things.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(ThingAttribute... things);

        /**
         * <p>
         * The things.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ThingAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<ThingAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ThingAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #things(List<ThingAttribute>)}.
         * 
         * @param things
         *        a consumer that will call methods on {@link List<ThingAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #things(List<ThingAttribute>)
         */
        Builder things(Consumer<ThingAttribute.Builder>... things);

        /**
         * <p>
         * The token for the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private List<ThingAttribute> things;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingsResponse model) {
            super(model);
            things(model.things);
            nextToken(model.nextToken);
        }

        public final Collection<ThingAttribute.Builder> getThings() {
            return things != null ? things.stream().map(ThingAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder things(Collection<ThingAttribute> things) {
            this.things = ThingAttributeListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(ThingAttribute... things) {
            things(Arrays.asList(things));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(Consumer<ThingAttribute.Builder>... things) {
            things(Stream.of(things).map(c -> ThingAttribute.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThings(Collection<ThingAttribute.BuilderImpl> things) {
            this.things = ThingAttributeListCopier.copyFromBuilder(things);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingsResponse build() {
            return new ListThingsResponse(this);
        }
    }
}
