/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input to the RegisterCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterCertificateRequest extends IoTRequest implements
        ToCopyableBuilder<RegisterCertificateRequest.Builder, RegisterCertificateRequest> {
    private final String certificatePem;

    private final String caCertificatePem;

    private final Boolean setAsActive;

    private final String status;

    private RegisterCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificatePem = builder.certificatePem;
        this.caCertificatePem = builder.caCertificatePem;
        this.setAsActive = builder.setAsActive;
        this.status = builder.status;
    }

    /**
     * <p>
     * The certificate data, in PEM format.
     * </p>
     * 
     * @return The certificate data, in PEM format.
     */
    public String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The CA certificate used to sign the device certificate being registered.
     * </p>
     * 
     * @return The CA certificate used to sign the device certificate being registered.
     */
    public String caCertificatePem() {
        return caCertificatePem;
    }

    /**
     * <p>
     * A boolean value that specifies if the CA certificate is set to active.
     * </p>
     * 
     * @return A boolean value that specifies if the CA certificate is set to active.
     */
    public Boolean setAsActive() {
        return setAsActive;
    }

    /**
     * <p>
     * The status of the register certificate request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the register certificate request.
     * @see CertificateStatus
     */
    public CertificateStatus status() {
        return CertificateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the register certificate request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the register certificate request.
     * @see CertificateStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(setAsActive());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCertificateRequest)) {
            return false;
        }
        RegisterCertificateRequest other = (RegisterCertificateRequest) obj;
        return Objects.equals(certificatePem(), other.certificatePem())
                && Objects.equals(caCertificatePem(), other.caCertificatePem())
                && Objects.equals(setAsActive(), other.setAsActive()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterCertificateRequest").add("CertificatePem", certificatePem())
                .add("CaCertificatePem", caCertificatePem()).add("SetAsActive", setAsActive()).add("Status", statusAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificatePem":
            return Optional.of(clazz.cast(certificatePem()));
        case "caCertificatePem":
            return Optional.of(clazz.cast(caCertificatePem()));
        case "setAsActive":
            return Optional.of(clazz.cast(setAsActive()));
        case "status":
            return Optional.of(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTRequest.Builder, CopyableBuilder<Builder, RegisterCertificateRequest> {
        /**
         * <p>
         * The certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The CA certificate used to sign the device certificate being registered.
         * </p>
         * 
         * @param caCertificatePem
         *        The CA certificate used to sign the device certificate being registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificatePem(String caCertificatePem);

        /**
         * <p>
         * A boolean value that specifies if the CA certificate is set to active.
         * </p>
         * 
         * @param setAsActive
         *        A boolean value that specifies if the CA certificate is set to active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setAsActive(Boolean setAsActive);

        /**
         * <p>
         * The status of the register certificate request.
         * </p>
         * 
         * @param status
         *        The status of the register certificate request.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the register certificate request.
         * </p>
         * 
         * @param status
         *        The status of the register certificate request.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(CertificateStatus status);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTRequest.BuilderImpl implements Builder {
        private String certificatePem;

        private String caCertificatePem;

        private Boolean setAsActive;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCertificateRequest model) {
            super(model);
            certificatePem(model.certificatePem);
            caCertificatePem(model.caCertificatePem);
            setAsActive(model.setAsActive);
            status(model.status);
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getCaCertificatePem() {
            return caCertificatePem;
        }

        @Override
        public final Builder caCertificatePem(String caCertificatePem) {
            this.caCertificatePem = caCertificatePem;
            return this;
        }

        public final void setCaCertificatePem(String caCertificatePem) {
            this.caCertificatePem = caCertificatePem;
        }

        public final Boolean getSetAsActive() {
            return setAsActive;
        }

        @Override
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterCertificateRequest build() {
            return new RegisterCertificateRequest(this);
        }
    }
}
