/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the SetLoggingOptions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetLoggingOptionsRequest extends IoTRequest implements
        ToCopyableBuilder<SetLoggingOptionsRequest.Builder, SetLoggingOptionsRequest> {
    private final LoggingOptionsPayload loggingOptionsPayload;

    private SetLoggingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.loggingOptionsPayload = builder.loggingOptionsPayload;
    }

    /**
     * <p>
     * The logging options payload.
     * </p>
     * 
     * @return The logging options payload.
     */
    public LoggingOptionsPayload loggingOptionsPayload() {
        return loggingOptionsPayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loggingOptionsPayload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoggingOptionsRequest)) {
            return false;
        }
        SetLoggingOptionsRequest other = (SetLoggingOptionsRequest) obj;
        return Objects.equals(loggingOptionsPayload(), other.loggingOptionsPayload());
    }

    @Override
    public String toString() {
        return ToString.builder("SetLoggingOptionsRequest").add("LoggingOptionsPayload", loggingOptionsPayload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loggingOptionsPayload":
            return Optional.of(clazz.cast(loggingOptionsPayload()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTRequest.Builder, CopyableBuilder<Builder, SetLoggingOptionsRequest> {
        /**
         * <p>
         * The logging options payload.
         * </p>
         * 
         * @param loggingOptionsPayload
         *        The logging options payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingOptionsPayload(LoggingOptionsPayload loggingOptionsPayload);

        /**
         * <p>
         * The logging options payload.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingOptionsPayload.Builder} avoiding the need
         * to create one manually via {@link LoggingOptionsPayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingOptionsPayload.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingOptionsPayload(LoggingOptionsPayload)}.
         * 
         * @param loggingOptionsPayload
         *        a consumer that will call methods on {@link LoggingOptionsPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingOptionsPayload(LoggingOptionsPayload)
         */
        default Builder loggingOptionsPayload(Consumer<LoggingOptionsPayload.Builder> loggingOptionsPayload) {
            return loggingOptionsPayload(LoggingOptionsPayload.builder().apply(loggingOptionsPayload).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTRequest.BuilderImpl implements Builder {
        private LoggingOptionsPayload loggingOptionsPayload;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoggingOptionsRequest model) {
            super(model);
            loggingOptionsPayload(model.loggingOptionsPayload);
        }

        public final LoggingOptionsPayload.Builder getLoggingOptionsPayload() {
            return loggingOptionsPayload != null ? loggingOptionsPayload.toBuilder() : null;
        }

        @Override
        public final Builder loggingOptionsPayload(LoggingOptionsPayload loggingOptionsPayload) {
            this.loggingOptionsPayload = loggingOptionsPayload;
            return this;
        }

        public final void setLoggingOptionsPayload(LoggingOptionsPayload.BuilderImpl loggingOptionsPayload) {
            this.loggingOptionsPayload = loggingOptionsPayload != null ? loggingOptionsPayload.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetLoggingOptionsRequest build() {
            return new SetLoggingOptionsRequest(this);
        }
    }
}
