/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.Action;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Action} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ActionMarshaller {
    private static final MarshallingInfo<StructuredPojo> DYNAMODB_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamoDB").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DYNAMODBV2_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamoDBv2").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LAMBDA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambda").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SNS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sns").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SQS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sqs").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESIS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kinesis").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> REPUBLISH_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("republish").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> FIREHOSE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firehose").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHMETRIC_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("cloudwatchMetric").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHALARM_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("cloudwatchAlarm").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCH_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("elasticsearch")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SALESFORCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("salesforce").isBinary(false).build();

    private static final ActionMarshaller INSTANCE = new ActionMarshaller();

    private ActionMarshaller() {
    }

    public static ActionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Action action, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(action, "action");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(action.dynamoDB(), DYNAMODB_BINDING);
            protocolMarshaller.marshall(action.dynamoDBv2(), DYNAMODBV2_BINDING);
            protocolMarshaller.marshall(action.lambda(), LAMBDA_BINDING);
            protocolMarshaller.marshall(action.sns(), SNS_BINDING);
            protocolMarshaller.marshall(action.sqs(), SQS_BINDING);
            protocolMarshaller.marshall(action.kinesis(), KINESIS_BINDING);
            protocolMarshaller.marshall(action.republish(), REPUBLISH_BINDING);
            protocolMarshaller.marshall(action.s3(), S3_BINDING);
            protocolMarshaller.marshall(action.firehose(), FIREHOSE_BINDING);
            protocolMarshaller.marshall(action.cloudwatchMetric(), CLOUDWATCHMETRIC_BINDING);
            protocolMarshaller.marshall(action.cloudwatchAlarm(), CLOUDWATCHALARM_BINDING);
            protocolMarshaller.marshall(action.elasticsearch(), ELASTICSEARCH_BINDING);
            protocolMarshaller.marshall(action.salesforce(), SALESFORCE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
