/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TransferData;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link TransferData} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class TransferDataMarshaller {
    private static final MarshallingInfo<String> TRANSFERMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferMessage").isBinary(false).build();

    private static final MarshallingInfo<String> REJECTREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectReason").isBinary(false).build();

    private static final MarshallingInfo<Instant> TRANSFERDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> ACCEPTDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("acceptDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> REJECTDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectDate").isBinary(false).build();

    private static final TransferDataMarshaller INSTANCE = new TransferDataMarshaller();

    private TransferDataMarshaller() {
    }

    public static TransferDataMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(TransferData transferData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(transferData, "transferData");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(transferData.transferMessage(), TRANSFERMESSAGE_BINDING);
            protocolMarshaller.marshall(transferData.rejectReason(), REJECTREASON_BINDING);
            protocolMarshaller.marshall(transferData.transferDate(), TRANSFERDATE_BINDING);
            protocolMarshaller.marshall(transferData.acceptDate(), ACCEPTDATE_BINDING);
            protocolMarshaller.marshall(transferData.rejectDate(), REJECTDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
