/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the UpdateThingShadow operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateThingShadowRequest extends IoTDataPlaneRequest implements
        ToCopyableBuilder<UpdateThingShadowRequest.Builder, UpdateThingShadowRequest> {
    private final String thingName;

    private final ByteBuffer payload;

    private UpdateThingShadowRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The name of the thing.
     * </p>
     * 
     * @return The name of the thing.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The state information, in JSON format.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The state information, in JSON format.
     */
    public ByteBuffer payload() {
        return payload == null ? null : payload.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingShadowRequest)) {
            return false;
        }
        UpdateThingShadowRequest other = (UpdateThingShadowRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(payload(), other.payload());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateThingShadowRequest").add("ThingName", thingName()).add("Payload", payload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.of(clazz.cast(thingName()));
        case "payload":
            return Optional.of(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTDataPlaneRequest.Builder, CopyableBuilder<Builder, UpdateThingShadowRequest> {
        /**
         * <p>
         * The name of the thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The state information, in JSON format.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param payload
         *        The state information, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(ByteBuffer payload);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTDataPlaneRequest.BuilderImpl implements Builder {
        private String thingName;

        private ByteBuffer payload;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingShadowRequest model) {
            super(model);
            thingName(model.thingName);
            payload(model.payload);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final ByteBuffer getPayload() {
            return payload;
        }

        @Override
        public final Builder payload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy(payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy(payload);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingShadowRequest build() {
            return new UpdateThingShadowRequest(this);
        }
    }
}
