/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.PolicyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Policy
implements StructuredPojo,
ToCopyableBuilder<Builder, Policy> {
    private final String policyName;
    private final String policyArn;

    private Policy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyArn = builder.policyArn;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyArn(), other.policyArn());
    }

    public String toString() {
        return ToString.builder((String)"Policy").add("PolicyName", (Object)this.policyName()).add("PolicyArn", (Object)this.policyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "policyArn": {
                return Optional.of(clazz.cast(this.policyArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Policy model) {
            this.policyName(model.policyName);
            this.policyArn(model.policyArn);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public Policy build() {
            return new Policy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Policy> {
        public Builder policyName(String var1);

        public Builder policyArn(String var1);
    }
}

