/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.AutoRegistrationStatus;
import software.amazon.awssdk.services.iot.model.CACertificateStatus;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateCACertificateRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, UpdateCACertificateRequest> {
    private final String certificateId;
    private final String newStatus;
    private final String newAutoRegistrationStatus;

    private UpdateCACertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.newStatus = builder.newStatus;
        this.newAutoRegistrationStatus = builder.newAutoRegistrationStatus;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public CACertificateStatus newStatus() {
        return CACertificateStatus.fromValue(this.newStatus);
    }

    public String newStatusAsString() {
        return this.newStatus;
    }

    public AutoRegistrationStatus newAutoRegistrationStatus() {
        return AutoRegistrationStatus.fromValue(this.newAutoRegistrationStatus);
    }

    public String newAutoRegistrationStatusAsString() {
        return this.newAutoRegistrationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.newAutoRegistrationStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCACertificateRequest)) {
            return false;
        }
        UpdateCACertificateRequest other = (UpdateCACertificateRequest)((Object)obj);
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.newStatusAsString(), other.newStatusAsString()) && Objects.equals(this.newAutoRegistrationStatusAsString(), other.newAutoRegistrationStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCACertificateRequest").add("CertificateId", (Object)this.certificateId()).add("NewStatus", (Object)this.newStatusAsString()).add("NewAutoRegistrationStatus", (Object)this.newAutoRegistrationStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateId": {
                return Optional.of(clazz.cast(this.certificateId()));
            }
            case "newStatus": {
                return Optional.of(clazz.cast(this.newStatusAsString()));
            }
            case "newAutoRegistrationStatus": {
                return Optional.of(clazz.cast(this.newAutoRegistrationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String certificateId;
        private String newStatus;
        private String newAutoRegistrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCACertificateRequest model) {
            super(model);
            this.certificateId(model.certificateId);
            this.newStatus(model.newStatus);
            this.newAutoRegistrationStatus(model.newAutoRegistrationStatus);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getNewStatus() {
            return this.newStatus;
        }

        @Override
        public final Builder newStatus(String newStatus) {
            this.newStatus = newStatus;
            return this;
        }

        @Override
        public final Builder newStatus(CACertificateStatus newStatus) {
            this.newStatus(newStatus.toString());
            return this;
        }

        public final void setNewStatus(String newStatus) {
            this.newStatus = newStatus;
        }

        public final String getNewAutoRegistrationStatus() {
            return this.newAutoRegistrationStatus;
        }

        @Override
        public final Builder newAutoRegistrationStatus(String newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus = newAutoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder newAutoRegistrationStatus(AutoRegistrationStatus newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus(newAutoRegistrationStatus.toString());
            return this;
        }

        public final void setNewAutoRegistrationStatus(String newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus = newAutoRegistrationStatus;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateCACertificateRequest build() {
            return new UpdateCACertificateRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, UpdateCACertificateRequest> {
        public Builder certificateId(String var1);

        public Builder newStatus(String var1);

        public Builder newStatus(CACertificateStatus var1);

        public Builder newAutoRegistrationStatus(String var1);

        public Builder newAutoRegistrationStatus(AutoRegistrationStatus var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

