/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CloudwatchAlarmAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CloudwatchAlarmActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> ALARMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alarmName").isBinary(false).build();
    private static final MarshallingInfo<String> STATEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateReason").isBinary(false).build();
    private static final MarshallingInfo<String> STATEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateValue").isBinary(false).build();
    private static final CloudwatchAlarmActionMarshaller INSTANCE = new CloudwatchAlarmActionMarshaller();

    private CloudwatchAlarmActionMarshaller() {
    }

    public static CloudwatchAlarmActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudwatchAlarmAction cloudwatchAlarmAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cloudwatchAlarmAction, (String)"cloudwatchAlarmAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cloudwatchAlarmAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchAlarmAction.alarmName(), ALARMNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchAlarmAction.stateReason(), STATEREASON_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchAlarmAction.stateValue(), STATEVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

