/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.KeyPair;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KeyPairMarshaller {
    private static final MarshallingInfo<String> PUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicKey").isBinary(false).build();
    private static final MarshallingInfo<String> PRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateKey").isBinary(false).build();
    private static final KeyPairMarshaller INSTANCE = new KeyPairMarshaller();

    private KeyPairMarshaller() {
    }

    public static KeyPairMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyPair keyPair, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)keyPair, (String)"keyPair");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)keyPair.publicKey(), PUBLICKEY_BINDING);
            protocolMarshaller.marshall((Object)keyPair.privateKey(), PRIVATEKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

