/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.S3Action;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3ActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").isBinary(false).build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").isBinary(false).build();
    private static final MarshallingInfo<String> CANNEDACL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cannedAcl").isBinary(false).build();
    private static final S3ActionMarshaller INSTANCE = new S3ActionMarshaller();

    private S3ActionMarshaller() {
    }

    public static S3ActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3Action s3Action, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3Action, (String)"s3Action");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3Action.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)s3Action.bucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3Action.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)s3Action.cannedAclAsString(), CANNEDACL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

