/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CertificateDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateDescription implements StructuredPojo,
        ToCopyableBuilder<CertificateDescription.Builder, CertificateDescription> {
    private final String certificateArn;

    private final String certificateId;

    private final String caCertificateId;

    private final String status;

    private final String certificatePem;

    private final String ownedBy;

    private final String previousOwnedBy;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final TransferData transferData;

    private CertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.caCertificateId = builder.caCertificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.previousOwnedBy = builder.previousOwnedBy;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.transferData = builder.transferData;
    }

    /**
     * <p>
     * The ARN of the certificate.
     * </p>
     * 
     * @return The ARN of the certificate.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The ID of the certificate.
     * </p>
     * 
     * @return The ID of the certificate.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The certificate ID of the CA certificate used to sign this certificate.
     * </p>
     * 
     * @return The certificate ID of the CA certificate used to sign this certificate.
     */
    public String caCertificateId() {
        return caCertificateId;
    }

    /**
     * <p>
     * The status of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the certificate.
     * @see CertificateStatus
     */
    public CertificateStatus status() {
        return CertificateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the certificate.
     * @see CertificateStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The certificate data, in PEM format.
     * </p>
     * 
     * @return The certificate data, in PEM format.
     */
    public String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the certificate.
     * </p>
     * 
     * @return The ID of the AWS account that owns the certificate.
     */
    public String ownedBy() {
        return ownedBy;
    }

    /**
     * <p>
     * The ID of the AWS account of the previous owner of the certificate.
     * </p>
     * 
     * @return The ID of the AWS account of the previous owner of the certificate.
     */
    public String previousOwnedBy() {
        return previousOwnedBy;
    }

    /**
     * <p>
     * The date and time the certificate was created.
     * </p>
     * 
     * @return The date and time the certificate was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time the certificate was last modified.
     * </p>
     * 
     * @return The date and time the certificate was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The transfer data.
     * </p>
     * 
     * @return The transfer data.
     */
    public TransferData transferData() {
        return transferData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(previousOwnedBy());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(transferData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateDescription)) {
            return false;
        }
        CertificateDescription other = (CertificateDescription) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(caCertificateId(), other.caCertificateId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(certificatePem(), other.certificatePem()) && Objects.equals(ownedBy(), other.ownedBy())
                && Objects.equals(previousOwnedBy(), other.previousOwnedBy())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(transferData(), other.transferData());
    }

    @Override
    public String toString() {
        return ToString.builder("CertificateDescription").add("CertificateArn", certificateArn())
                .add("CertificateId", certificateId()).add("CaCertificateId", caCertificateId()).add("Status", statusAsString())
                .add("CertificatePem", certificatePem()).add("OwnedBy", ownedBy()).add("PreviousOwnedBy", previousOwnedBy())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate())
                .add("TransferData", transferData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "caCertificateId":
            return Optional.ofNullable(clazz.cast(caCertificateId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "certificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        case "ownedBy":
            return Optional.ofNullable(clazz.cast(ownedBy()));
        case "previousOwnedBy":
            return Optional.ofNullable(clazz.cast(previousOwnedBy()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "transferData":
            return Optional.ofNullable(clazz.cast(transferData()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CertificateDescription> {
        /**
         * <p>
         * The ARN of the certificate.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The ID of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The certificate ID of the CA certificate used to sign this certificate.
         * </p>
         * 
         * @param caCertificateId
         *        The certificate ID of the CA certificate used to sign this certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateId(String caCertificateId);

        /**
         * <p>
         * The status of the certificate.
         * </p>
         * 
         * @param status
         *        The status of the certificate.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the certificate.
         * </p>
         * 
         * @param status
         *        The status of the certificate.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(CertificateStatus status);

        /**
         * <p>
         * The certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The ID of the AWS account that owns the certificate.
         * </p>
         * 
         * @param ownedBy
         *        The ID of the AWS account that owns the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownedBy(String ownedBy);

        /**
         * <p>
         * The ID of the AWS account of the previous owner of the certificate.
         * </p>
         * 
         * @param previousOwnedBy
         *        The ID of the AWS account of the previous owner of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousOwnedBy(String previousOwnedBy);

        /**
         * <p>
         * The date and time the certificate was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time the certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time the certificate was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time the certificate was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The transfer data.
         * </p>
         * 
         * @param transferData
         *        The transfer data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferData(TransferData transferData);

        /**
         * <p>
         * The transfer data.
         * </p>
         * This is a convenience that creates an instance of the {@link TransferData.Builder} avoiding the need to
         * create one manually via {@link TransferData#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransferData.Builder#build()} is called immediately and its
         * result is passed to {@link #transferData(TransferData)}.
         * 
         * @param transferData
         *        a consumer that will call methods on {@link TransferData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transferData(TransferData)
         */
        default Builder transferData(Consumer<TransferData.Builder> transferData) {
            return transferData(TransferData.builder().applyMutation(transferData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String caCertificateId;

        private String status;

        private String certificatePem;

        private String ownedBy;

        private String previousOwnedBy;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private TransferData transferData;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateDescription model) {
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
            caCertificateId(model.caCertificateId);
            status(model.status);
            certificatePem(model.certificatePem);
            ownedBy(model.ownedBy);
            previousOwnedBy(model.previousOwnedBy);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            transferData(model.transferData);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCaCertificateId() {
            return caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getOwnedBy() {
            return ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        public final String getPreviousOwnedBy() {
            return previousOwnedBy;
        }

        @Override
        public final Builder previousOwnedBy(String previousOwnedBy) {
            this.previousOwnedBy = previousOwnedBy;
            return this;
        }

        public final void setPreviousOwnedBy(String previousOwnedBy) {
            this.previousOwnedBy = previousOwnedBy;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final TransferData.Builder getTransferData() {
            return transferData != null ? transferData.toBuilder() : null;
        }

        @Override
        public final Builder transferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public final void setTransferData(TransferData.BuilderImpl transferData) {
            this.transferData = transferData != null ? transferData.build() : null;
        }

        @Override
        public CertificateDescription build() {
            return new CertificateDescription(this);
        }
    }
}
