/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the DescribeCACertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCaCertificateResponse extends IotResponse implements
        ToCopyableBuilder<DescribeCaCertificateResponse.Builder, DescribeCaCertificateResponse> {
    private final CACertificateDescription certificateDescription;

    private DescribeCaCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificateDescription = builder.certificateDescription;
    }

    /**
     * <p>
     * The CA certificate description.
     * </p>
     * 
     * @return The CA certificate description.
     */
    public CACertificateDescription certificateDescription() {
        return certificateDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCaCertificateResponse)) {
            return false;
        }
        DescribeCaCertificateResponse other = (DescribeCaCertificateResponse) obj;
        return Objects.equals(certificateDescription(), other.certificateDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeCaCertificateResponse").add("CertificateDescription", certificateDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateDescription":
            return Optional.ofNullable(clazz.cast(certificateDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, DescribeCaCertificateResponse> {
        /**
         * <p>
         * The CA certificate description.
         * </p>
         * 
         * @param certificateDescription
         *        The CA certificate description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateDescription(CACertificateDescription certificateDescription);

        /**
         * <p>
         * The CA certificate description.
         * </p>
         * This is a convenience that creates an instance of the {@link CACertificateDescription.Builder} avoiding the
         * need to create one manually via {@link CACertificateDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link CACertificateDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #certificateDescription(CACertificateDescription)}.
         * 
         * @param certificateDescription
         *        a consumer that will call methods on {@link CACertificateDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateDescription(CACertificateDescription)
         */
        default Builder certificateDescription(Consumer<CACertificateDescription.Builder> certificateDescription) {
            return certificateDescription(CACertificateDescription.builder().applyMutation(certificateDescription).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private CACertificateDescription certificateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCaCertificateResponse model) {
            super(model);
            certificateDescription(model.certificateDescription);
        }

        public final CACertificateDescription.Builder getCertificateDescription() {
            return certificateDescription != null ? certificateDescription.toBuilder() : null;
        }

        @Override
        public final Builder certificateDescription(CACertificateDescription certificateDescription) {
            this.certificateDescription = certificateDescription;
            return this;
        }

        public final void setCertificateDescription(CACertificateDescription.BuilderImpl certificateDescription) {
            this.certificateDescription = certificateDescription != null ? certificateDescription.build() : null;
        }

        @Override
        public DescribeCaCertificateResponse build() {
            return new DescribeCaCertificateResponse(this);
        }
    }
}
