/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.DynamoDBv2ActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write to a DynamoDB table.
 * </p>
 * <p>
 * This DynamoDB action writes each attribute in the message payload into it's own column in the DynamoDB table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamoDBv2Action implements StructuredPojo, ToCopyableBuilder<DynamoDBv2Action.Builder, DynamoDBv2Action> {
    private final String roleArn;

    private final PutItemInput putItem;

    private DynamoDBv2Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.putItem = builder.putItem;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access to the DynamoDB table.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access to the DynamoDB table.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Specifies the DynamoDB table to which the message data will be written. For example:
     * </p>
     * <p>
     * <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
     * </p>
     * <p>
     * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
     * </p>
     * 
     * @return Specifies the DynamoDB table to which the message data will be written. For example:</p>
     *         <p>
     *         <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
     *         </p>
     *         <p>
     *         Each attribute in the message payload will be written to a separate column in the DynamoDB database.
     */
    public PutItemInput putItem() {
        return putItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(putItem());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBv2Action)) {
            return false;
        }
        DynamoDBv2Action other = (DynamoDBv2Action) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(putItem(), other.putItem());
    }

    @Override
    public String toString() {
        return ToString.builder("DynamoDBv2Action").add("RoleArn", roleArn()).add("PutItem", putItem()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "putItem":
            return Optional.ofNullable(clazz.cast(putItem()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamoDBv2ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DynamoDBv2Action> {
        /**
         * <p>
         * The ARN of the IAM role that grants access to the DynamoDB table.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access to the DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Specifies the DynamoDB table to which the message data will be written. For example:
         * </p>
         * <p>
         * <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
         * </p>
         * <p>
         * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         * </p>
         * 
         * @param putItem
         *        Specifies the DynamoDB table to which the message data will be written. For example:</p>
         *        <p>
         *        <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
         *        </p>
         *        <p>
         *        Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder putItem(PutItemInput putItem);

        /**
         * <p>
         * Specifies the DynamoDB table to which the message data will be written. For example:
         * </p>
         * <p>
         * <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
         * </p>
         * <p>
         * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         * </p>
         * This is a convenience that creates an instance of the {@link PutItemInput.Builder} avoiding the need to
         * create one manually via {@link PutItemInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link PutItemInput.Builder#build()} is called immediately and its
         * result is passed to {@link #putItem(PutItemInput)}.
         * 
         * @param putItem
         *        a consumer that will call methods on {@link PutItemInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #putItem(PutItemInput)
         */
        default Builder putItem(Consumer<PutItemInput.Builder> putItem) {
            return putItem(PutItemInput.builder().applyMutation(putItem).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private PutItemInput putItem;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBv2Action model) {
            roleArn(model.roleArn);
            putItem(model.putItem);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final PutItemInput.Builder getPutItem() {
            return putItem != null ? putItem.toBuilder() : null;
        }

        @Override
        public final Builder putItem(PutItemInput putItem) {
            this.putItem = putItem;
            return this;
        }

        public final void setPutItem(PutItemInput.BuilderImpl putItem) {
            this.putItem = putItem != null ? putItem.build() : null;
        }

        @Override
        public DynamoDBv2Action build() {
            return new DynamoDBv2Action(this);
        }
    }
}
