/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.OutgoingCertificateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A certificate that has been transfered but not yet accepted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutgoingCertificate implements StructuredPojo,
        ToCopyableBuilder<OutgoingCertificate.Builder, OutgoingCertificate> {
    private final String certificateArn;

    private final String certificateId;

    private final String transferredTo;

    private final Instant transferDate;

    private final String transferMessage;

    private final Instant creationDate;

    private OutgoingCertificate(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.transferredTo = builder.transferredTo;
        this.transferDate = builder.transferDate;
        this.transferMessage = builder.transferMessage;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The certificate ARN.
     * </p>
     * 
     * @return The certificate ARN.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The certificate ID.
     * </p>
     * 
     * @return The certificate ID.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The AWS account to which the transfer was made.
     * </p>
     * 
     * @return The AWS account to which the transfer was made.
     */
    public String transferredTo() {
        return transferredTo;
    }

    /**
     * <p>
     * The date the transfer was initiated.
     * </p>
     * 
     * @return The date the transfer was initiated.
     */
    public Instant transferDate() {
        return transferDate;
    }

    /**
     * <p>
     * The transfer message.
     * </p>
     * 
     * @return The transfer message.
     */
    public String transferMessage() {
        return transferMessage;
    }

    /**
     * <p>
     * The certificate creation date.
     * </p>
     * 
     * @return The certificate creation date.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(transferredTo());
        hashCode = 31 * hashCode + Objects.hashCode(transferDate());
        hashCode = 31 * hashCode + Objects.hashCode(transferMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutgoingCertificate)) {
            return false;
        }
        OutgoingCertificate other = (OutgoingCertificate) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(transferredTo(), other.transferredTo()) && Objects.equals(transferDate(), other.transferDate())
                && Objects.equals(transferMessage(), other.transferMessage())
                && Objects.equals(creationDate(), other.creationDate());
    }

    @Override
    public String toString() {
        return ToString.builder("OutgoingCertificate").add("CertificateArn", certificateArn())
                .add("CertificateId", certificateId()).add("TransferredTo", transferredTo()).add("TransferDate", transferDate())
                .add("TransferMessage", transferMessage()).add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "transferredTo":
            return Optional.ofNullable(clazz.cast(transferredTo()));
        case "transferDate":
            return Optional.ofNullable(clazz.cast(transferDate()));
        case "transferMessage":
            return Optional.ofNullable(clazz.cast(transferMessage()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutgoingCertificateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OutgoingCertificate> {
        /**
         * <p>
         * The certificate ARN.
         * </p>
         * 
         * @param certificateArn
         *        The certificate ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The certificate ID.
         * </p>
         * 
         * @param certificateId
         *        The certificate ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The AWS account to which the transfer was made.
         * </p>
         * 
         * @param transferredTo
         *        The AWS account to which the transfer was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferredTo(String transferredTo);

        /**
         * <p>
         * The date the transfer was initiated.
         * </p>
         * 
         * @param transferDate
         *        The date the transfer was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferDate(Instant transferDate);

        /**
         * <p>
         * The transfer message.
         * </p>
         * 
         * @param transferMessage
         *        The transfer message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferMessage(String transferMessage);

        /**
         * <p>
         * The certificate creation date.
         * </p>
         * 
         * @param creationDate
         *        The certificate creation date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String transferredTo;

        private Instant transferDate;

        private String transferMessage;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OutgoingCertificate model) {
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
            transferredTo(model.transferredTo);
            transferDate(model.transferDate);
            transferMessage(model.transferMessage);
            creationDate(model.creationDate);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getTransferredTo() {
            return transferredTo;
        }

        @Override
        public final Builder transferredTo(String transferredTo) {
            this.transferredTo = transferredTo;
            return this;
        }

        public final void setTransferredTo(String transferredTo) {
            this.transferredTo = transferredTo;
        }

        public final Instant getTransferDate() {
            return transferDate;
        }

        @Override
        public final Builder transferDate(Instant transferDate) {
            this.transferDate = transferDate;
            return this;
        }

        public final void setTransferDate(Instant transferDate) {
            this.transferDate = transferDate;
        }

        public final String getTransferMessage() {
            return transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public OutgoingCertificate build() {
            return new OutgoingCertificate(this);
        }
    }
}
