/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input to the RegisterCACertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterCaCertificateRequest extends IotRequest implements
        ToCopyableBuilder<RegisterCaCertificateRequest.Builder, RegisterCaCertificateRequest> {
    private final String caCertificate;

    private final String verificationCertificate;

    private final Boolean setAsActive;

    private final Boolean allowAutoRegistration;

    private RegisterCaCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.caCertificate = builder.caCertificate;
        this.verificationCertificate = builder.verificationCertificate;
        this.setAsActive = builder.setAsActive;
        this.allowAutoRegistration = builder.allowAutoRegistration;
    }

    /**
     * <p>
     * The CA certificate.
     * </p>
     * 
     * @return The CA certificate.
     */
    public String caCertificate() {
        return caCertificate;
    }

    /**
     * <p>
     * The private key verification certificate.
     * </p>
     * 
     * @return The private key verification certificate.
     */
    public String verificationCertificate() {
        return verificationCertificate;
    }

    /**
     * <p>
     * A boolean value that specifies if the CA certificate is set to active.
     * </p>
     * 
     * @return A boolean value that specifies if the CA certificate is set to active.
     */
    public Boolean setAsActive() {
        return setAsActive;
    }

    /**
     * <p>
     * Allows this CA certificate to be used for auto registration of device certificates.
     * </p>
     * 
     * @return Allows this CA certificate to be used for auto registration of device certificates.
     */
    public Boolean allowAutoRegistration() {
        return allowAutoRegistration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(verificationCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(setAsActive());
        hashCode = 31 * hashCode + Objects.hashCode(allowAutoRegistration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCaCertificateRequest)) {
            return false;
        }
        RegisterCaCertificateRequest other = (RegisterCaCertificateRequest) obj;
        return Objects.equals(caCertificate(), other.caCertificate())
                && Objects.equals(verificationCertificate(), other.verificationCertificate())
                && Objects.equals(setAsActive(), other.setAsActive())
                && Objects.equals(allowAutoRegistration(), other.allowAutoRegistration());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterCaCertificateRequest").add("CaCertificate", caCertificate())
                .add("VerificationCertificate", verificationCertificate()).add("SetAsActive", setAsActive())
                .add("AllowAutoRegistration", allowAutoRegistration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caCertificate":
            return Optional.ofNullable(clazz.cast(caCertificate()));
        case "verificationCertificate":
            return Optional.ofNullable(clazz.cast(verificationCertificate()));
        case "setAsActive":
            return Optional.ofNullable(clazz.cast(setAsActive()));
        case "allowAutoRegistration":
            return Optional.ofNullable(clazz.cast(allowAutoRegistration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, RegisterCaCertificateRequest> {
        /**
         * <p>
         * The CA certificate.
         * </p>
         * 
         * @param caCertificate
         *        The CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificate(String caCertificate);

        /**
         * <p>
         * The private key verification certificate.
         * </p>
         * 
         * @param verificationCertificate
         *        The private key verification certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationCertificate(String verificationCertificate);

        /**
         * <p>
         * A boolean value that specifies if the CA certificate is set to active.
         * </p>
         * 
         * @param setAsActive
         *        A boolean value that specifies if the CA certificate is set to active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setAsActive(Boolean setAsActive);

        /**
         * <p>
         * Allows this CA certificate to be used for auto registration of device certificates.
         * </p>
         * 
         * @param allowAutoRegistration
         *        Allows this CA certificate to be used for auto registration of device certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAutoRegistration(Boolean allowAutoRegistration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String caCertificate;

        private String verificationCertificate;

        private Boolean setAsActive;

        private Boolean allowAutoRegistration;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCaCertificateRequest model) {
            super(model);
            caCertificate(model.caCertificate);
            verificationCertificate(model.verificationCertificate);
            setAsActive(model.setAsActive);
            allowAutoRegistration(model.allowAutoRegistration);
        }

        public final String getCaCertificate() {
            return caCertificate;
        }

        @Override
        public final Builder caCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
            return this;
        }

        public final void setCaCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
        }

        public final String getVerificationCertificate() {
            return verificationCertificate;
        }

        @Override
        public final Builder verificationCertificate(String verificationCertificate) {
            this.verificationCertificate = verificationCertificate;
            return this;
        }

        public final void setVerificationCertificate(String verificationCertificate) {
            this.verificationCertificate = verificationCertificate;
        }

        public final Boolean getSetAsActive() {
            return setAsActive;
        }

        @Override
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        public final Boolean getAllowAutoRegistration() {
            return allowAutoRegistration;
        }

        @Override
        public final Builder allowAutoRegistration(Boolean allowAutoRegistration) {
            this.allowAutoRegistration = allowAutoRegistration;
            return this;
        }

        public final void setAllowAutoRegistration(Boolean allowAutoRegistration) {
            this.allowAutoRegistration = allowAutoRegistration;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterCaCertificateRequest build() {
            return new RegisterCaCertificateRequest(this);
        }
    }
}
