/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.transform.ThingAttributeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of the thing, including thing name, thing type name, and a list of thing attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingAttribute implements StructuredPojo, ToCopyableBuilder<ThingAttribute.Builder, ThingAttribute> {
    private final String thingName;

    private final String thingTypeName;

    private final Map<String, String> attributes;

    private final Long version;

    private ThingAttribute(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributes = builder.attributes;
        this.version = builder.version;
    }

    /**
     * <p>
     * The name of the thing.
     * </p>
     * 
     * @return The name of the thing.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The name of the thing type, if the thing has been associated with a type.
     * </p>
     * 
     * @return The name of the thing type, if the thing has been associated with a type.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * A list of thing attributes which are name-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of thing attributes which are name-value pairs.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The version of the thing record in the registry.
     * </p>
     * 
     * @return The version of the thing record in the registry.
     */
    public Long version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingAttribute)) {
            return false;
        }
        ThingAttribute other = (ThingAttribute) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingTypeName(), other.thingTypeName())
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(version(), other.version());
    }

    @Override
    public String toString() {
        return ToString.builder("ThingAttribute").add("ThingName", thingName()).add("ThingTypeName", thingTypeName())
                .add("Attributes", attributes()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ThingAttribute> {
        /**
         * <p>
         * The name of the thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The name of the thing type, if the thing has been associated with a type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type, if the thing has been associated with a type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * A list of thing attributes which are name-value pairs.
         * </p>
         * 
         * @param attributes
         *        A list of thing attributes which are name-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The version of the thing record in the registry.
         * </p>
         * 
         * @param version
         *        The version of the thing record in the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);
    }

    static final class BuilderImpl implements Builder {
        private String thingName;

        private String thingTypeName;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingAttribute model) {
            thingName(model.thingName);
            thingTypeName(model.thingTypeName);
            attributes(model.attributes);
            version(model.version);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public ThingAttribute build() {
            return new ThingAttribute(this);
        }
    }
}
