/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the UpdateThing operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateThingRequest extends IotRequest implements
        ToCopyableBuilder<UpdateThingRequest.Builder, UpdateThingRequest> {
    private final String thingName;

    private final String thingTypeName;

    private final AttributePayload attributePayload;

    private final Long expectedVersion;

    private final Boolean removeThingType;

    private UpdateThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributePayload = builder.attributePayload;
        this.expectedVersion = builder.expectedVersion;
        this.removeThingType = builder.removeThingType;
    }

    /**
     * <p>
     * The name of the thing to update.
     * </p>
     * 
     * @return The name of the thing to update.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The name of the thing type.
     * </p>
     * 
     * @return The name of the thing type.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * A list of thing attributes, a JSON string containing name-value pairs. For example:
     * </p>
     * <p>
     * <code>{\"attributes\":{\"name1\":\"value2\"}}</code>
     * </p>
     * <p>
     * This data is used to add new attributes or update existing attributes.
     * </p>
     * 
     * @return A list of thing attributes, a JSON string containing name-value pairs. For example:</p>
     *         <p>
     *         <code>{\"attributes\":{\"name1\":\"value2\"}}</code>
     *         </p>
     *         <p>
     *         This data is used to add new attributes or update existing attributes.
     */
    public AttributePayload attributePayload() {
        return attributePayload;
    }

    /**
     * <p>
     * The expected version of the thing record in the registry. If the version of the record in the registry does not
     * match the expected version specified in the request, the <code>UpdateThing</code> request is rejected with a
     * <code>VersionConflictException</code>.
     * </p>
     * 
     * @return The expected version of the thing record in the registry. If the version of the record in the registry
     *         does not match the expected version specified in the request, the <code>UpdateThing</code> request is
     *         rejected with a <code>VersionConflictException</code>.
     */
    public Long expectedVersion() {
        return expectedVersion;
    }

    /**
     * <p>
     * Remove a thing type association. If <b>true</b>, the assocation is removed.
     * </p>
     * 
     * @return Remove a thing type association. If <b>true</b>, the assocation is removed.
     */
    public Boolean removeThingType() {
        return removeThingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributePayload());
        hashCode = 31 * hashCode + Objects.hashCode(expectedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(removeThingType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingRequest)) {
            return false;
        }
        UpdateThingRequest other = (UpdateThingRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingTypeName(), other.thingTypeName())
                && Objects.equals(attributePayload(), other.attributePayload())
                && Objects.equals(expectedVersion(), other.expectedVersion())
                && Objects.equals(removeThingType(), other.removeThingType());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateThingRequest").add("ThingName", thingName()).add("ThingTypeName", thingTypeName())
                .add("AttributePayload", attributePayload()).add("ExpectedVersion", expectedVersion())
                .add("RemoveThingType", removeThingType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "attributePayload":
            return Optional.ofNullable(clazz.cast(attributePayload()));
        case "expectedVersion":
            return Optional.ofNullable(clazz.cast(expectedVersion()));
        case "removeThingType":
            return Optional.ofNullable(clazz.cast(removeThingType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, UpdateThingRequest> {
        /**
         * <p>
         * The name of the thing to update.
         * </p>
         * 
         * @param thingName
         *        The name of the thing to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The name of the thing type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * A list of thing attributes, a JSON string containing name-value pairs. For example:
         * </p>
         * <p>
         * <code>{\"attributes\":{\"name1\":\"value2\"}}</code>
         * </p>
         * <p>
         * This data is used to add new attributes or update existing attributes.
         * </p>
         * 
         * @param attributePayload
         *        A list of thing attributes, a JSON string containing name-value pairs. For example:</p>
         *        <p>
         *        <code>{\"attributes\":{\"name1\":\"value2\"}}</code>
         *        </p>
         *        <p>
         *        This data is used to add new attributes or update existing attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributePayload(AttributePayload attributePayload);

        /**
         * <p>
         * A list of thing attributes, a JSON string containing name-value pairs. For example:
         * </p>
         * <p>
         * <code>{\"attributes\":{\"name1\":\"value2\"}}</code>
         * </p>
         * <p>
         * This data is used to add new attributes or update existing attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributePayload.Builder} avoiding the need to
         * create one manually via {@link AttributePayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributePayload.Builder#build()} is called immediately and its
         * result is passed to {@link #attributePayload(AttributePayload)}.
         * 
         * @param attributePayload
         *        a consumer that will call methods on {@link AttributePayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributePayload(AttributePayload)
         */
        default Builder attributePayload(Consumer<AttributePayload.Builder> attributePayload) {
            return attributePayload(AttributePayload.builder().applyMutation(attributePayload).build());
        }

        /**
         * <p>
         * The expected version of the thing record in the registry. If the version of the record in the registry does
         * not match the expected version specified in the request, the <code>UpdateThing</code> request is rejected
         * with a <code>VersionConflictException</code>.
         * </p>
         * 
         * @param expectedVersion
         *        The expected version of the thing record in the registry. If the version of the record in the registry
         *        does not match the expected version specified in the request, the <code>UpdateThing</code> request is
         *        rejected with a <code>VersionConflictException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedVersion(Long expectedVersion);

        /**
         * <p>
         * Remove a thing type association. If <b>true</b>, the assocation is removed.
         * </p>
         * 
         * @param removeThingType
         *        Remove a thing type association. If <b>true</b>, the assocation is removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeThingType(Boolean removeThingType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingName;

        private String thingTypeName;

        private AttributePayload attributePayload;

        private Long expectedVersion;

        private Boolean removeThingType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingRequest model) {
            super(model);
            thingName(model.thingName);
            thingTypeName(model.thingTypeName);
            attributePayload(model.attributePayload);
            expectedVersion(model.expectedVersion);
            removeThingType(model.removeThingType);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final AttributePayload.Builder getAttributePayload() {
            return attributePayload != null ? attributePayload.toBuilder() : null;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final void setAttributePayload(AttributePayload.BuilderImpl attributePayload) {
            this.attributePayload = attributePayload != null ? attributePayload.build() : null;
        }

        public final Long getExpectedVersion() {
            return expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        public final Boolean getRemoveThingType() {
            return removeThingType;
        }

        @Override
        public final Builder removeThingType(Boolean removeThingType) {
            this.removeThingType = removeThingType;
            return this;
        }

        public final void setRemoveThingType(Boolean removeThingType) {
            this.removeThingType = removeThingType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingRequest build() {
            return new UpdateThingRequest(this);
        }
    }
}
