/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CACertificateDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CACertificateDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CACertificateDescriptionMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateId").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATEPEM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificatePem").isBinary(false).build();

    private static final MarshallingInfo<String> OWNEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownedBy").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();

    private static final MarshallingInfo<String> AUTOREGISTRATIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoRegistrationStatus").isBinary(false).build();

    private static final CACertificateDescriptionMarshaller INSTANCE = new CACertificateDescriptionMarshaller();

    private CACertificateDescriptionMarshaller() {
    }

    public static CACertificateDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CACertificateDescription caCertificateDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(caCertificateDescription, "caCertificateDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(caCertificateDescription.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall(caCertificateDescription.certificateId(), CERTIFICATEID_BINDING);
            protocolMarshaller.marshall(caCertificateDescription.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(caCertificateDescription.certificatePem(), CERTIFICATEPEM_BINDING);
            protocolMarshaller.marshall(caCertificateDescription.ownedBy(), OWNEDBY_BINDING);
            protocolMarshaller.marshall(caCertificateDescription.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller
                    .marshall(caCertificateDescription.autoRegistrationStatusAsString(), AUTOREGISTRATIONSTATUS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
