/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.DynamoDBAction;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DynamoDBAction} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DynamoDBActionMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tableName").isBinary(false).build();

    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();

    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operation").isBinary(false).build();

    private static final MarshallingInfo<String> HASHKEYFIELD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashKeyField").isBinary(false).build();

    private static final MarshallingInfo<String> HASHKEYVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashKeyValue").isBinary(false).build();

    private static final MarshallingInfo<String> HASHKEYTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashKeyType").isBinary(false).build();

    private static final MarshallingInfo<String> RANGEKEYFIELD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rangeKeyField").isBinary(false).build();

    private static final MarshallingInfo<String> RANGEKEYVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rangeKeyValue").isBinary(false).build();

    private static final MarshallingInfo<String> RANGEKEYTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rangeKeyType").isBinary(false).build();

    private static final MarshallingInfo<String> PAYLOADFIELD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("payloadField").isBinary(false).build();

    private static final DynamoDBActionMarshaller INSTANCE = new DynamoDBActionMarshaller();

    private DynamoDBActionMarshaller() {
    }

    public static DynamoDBActionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DynamoDBAction dynamoDBAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(dynamoDBAction, "dynamoDBAction");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(dynamoDBAction.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(dynamoDBAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(dynamoDBAction.operation(), OPERATION_BINDING);
            protocolMarshaller.marshall(dynamoDBAction.hashKeyField(), HASHKEYFIELD_BINDING);
            protocolMarshaller.marshall(dynamoDBAction.hashKeyValue(), HASHKEYVALUE_BINDING);
            protocolMarshaller.marshall(dynamoDBAction.hashKeyTypeAsString(), HASHKEYTYPE_BINDING);
            protocolMarshaller.marshall(dynamoDBAction.rangeKeyField(), RANGEKEYFIELD_BINDING);
            protocolMarshaller.marshall(dynamoDBAction.rangeKeyValue(), RANGEKEYVALUE_BINDING);
            protocolMarshaller.marshall(dynamoDBAction.rangeKeyTypeAsString(), RANGEKEYTYPE_BINDING);
            protocolMarshaller.marshall(dynamoDBAction.payloadField(), PAYLOADFIELD_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
