/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ListCertificatesByCaRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ListCertificatesByCaRequestModelMarshaller {
    private static final MarshallingInfo<String> CACERTIFICATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("caCertificateId").isBinary(false).build();

    private static final MarshallingInfo<Integer> PAGESIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("pageSize").isBinary(false).build();

    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("marker").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ASCENDINGORDER_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("isAscendingOrder").isBinary(false).build();

    private static final ListCertificatesByCaRequestModelMarshaller INSTANCE = new ListCertificatesByCaRequestModelMarshaller();

    private ListCertificatesByCaRequestModelMarshaller() {
    }

    public static ListCertificatesByCaRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ListCertificatesByCaRequest listCertificatesByCaRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(listCertificatesByCaRequest, "listCertificatesByCaRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(listCertificatesByCaRequest.caCertificateId(), CACERTIFICATEID_BINDING);
            protocolMarshaller.marshall(listCertificatesByCaRequest.pageSize(), PAGESIZE_BINDING);
            protocolMarshaller.marshall(listCertificatesByCaRequest.marker(), MARKER_BINDING);
            protocolMarshaller.marshall(listCertificatesByCaRequest.ascendingOrder(), ASCENDINGORDER_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
