/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the AcceptCertificateTransfer operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptCertificateTransferRequest extends IotRequest implements
        ToCopyableBuilder<AcceptCertificateTransferRequest.Builder, AcceptCertificateTransferRequest> {
    private final String certificateId;

    private final Boolean setAsActive;

    private AcceptCertificateTransferRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.setAsActive = builder.setAsActive;
    }

    /**
     * <p>
     * The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
     * </p>
     * 
     * @return The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * Specifies whether the certificate is active.
     * </p>
     * 
     * @return Specifies whether the certificate is active.
     */
    public Boolean setAsActive() {
        return setAsActive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(setAsActive());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptCertificateTransferRequest)) {
            return false;
        }
        AcceptCertificateTransferRequest other = (AcceptCertificateTransferRequest) obj;
        return Objects.equals(certificateId(), other.certificateId()) && Objects.equals(setAsActive(), other.setAsActive());
    }

    @Override
    public String toString() {
        return ToString.builder("AcceptCertificateTransferRequest").add("CertificateId", certificateId())
                .add("SetAsActive", setAsActive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "setAsActive":
            return Optional.ofNullable(clazz.cast(setAsActive()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, AcceptCertificateTransferRequest> {
        /**
         * <p>
         * The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * Specifies whether the certificate is active.
         * </p>
         * 
         * @param setAsActive
         *        Specifies whether the certificate is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setAsActive(Boolean setAsActive);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String certificateId;

        private Boolean setAsActive;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptCertificateTransferRequest model) {
            super(model);
            certificateId(model.certificateId);
            setAsActive(model.setAsActive);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final Boolean getSetAsActive() {
            return setAsActive;
        }

        @Override
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptCertificateTransferRequest build() {
            return new AcceptCertificateTransferRequest(this);
        }
    }
}
