/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ActiveViolationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an active Device Defender security profile behavior violation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveViolation implements StructuredPojo, ToCopyableBuilder<ActiveViolation.Builder, ActiveViolation> {
    private final String violationId;

    private final String thingName;

    private final String securityProfileName;

    private final Behavior behavior;

    private final MetricValue lastViolationValue;

    private final Instant lastViolationTime;

    private final Instant violationStartTime;

    private ActiveViolation(BuilderImpl builder) {
        this.violationId = builder.violationId;
        this.thingName = builder.thingName;
        this.securityProfileName = builder.securityProfileName;
        this.behavior = builder.behavior;
        this.lastViolationValue = builder.lastViolationValue;
        this.lastViolationTime = builder.lastViolationTime;
        this.violationStartTime = builder.violationStartTime;
    }

    /**
     * <p>
     * The ID of the active violation.
     * </p>
     * 
     * @return The ID of the active violation.
     */
    public String violationId() {
        return violationId;
    }

    /**
     * <p>
     * The name of the thing responsible for the active violation.
     * </p>
     * 
     * @return The name of the thing responsible for the active violation.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The security profile whose behavior is in violation.
     * </p>
     * 
     * @return The security profile whose behavior is in violation.
     */
    public String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The behavior which is being violated.
     * </p>
     * 
     * @return The behavior which is being violated.
     */
    public Behavior behavior() {
        return behavior;
    }

    /**
     * <p>
     * The value of the metric (the measurement) which caused the most recent violation.
     * </p>
     * 
     * @return The value of the metric (the measurement) which caused the most recent violation.
     */
    public MetricValue lastViolationValue() {
        return lastViolationValue;
    }

    /**
     * <p>
     * The time the most recent violation occurred.
     * </p>
     * 
     * @return The time the most recent violation occurred.
     */
    public Instant lastViolationTime() {
        return lastViolationTime;
    }

    /**
     * <p>
     * The time the violation started.
     * </p>
     * 
     * @return The time the violation started.
     */
    public Instant violationStartTime() {
        return violationStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(behavior());
        hashCode = 31 * hashCode + Objects.hashCode(lastViolationValue());
        hashCode = 31 * hashCode + Objects.hashCode(lastViolationTime());
        hashCode = 31 * hashCode + Objects.hashCode(violationStartTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveViolation)) {
            return false;
        }
        ActiveViolation other = (ActiveViolation) obj;
        return Objects.equals(violationId(), other.violationId()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(behavior(), other.behavior())
                && Objects.equals(lastViolationValue(), other.lastViolationValue())
                && Objects.equals(lastViolationTime(), other.lastViolationTime())
                && Objects.equals(violationStartTime(), other.violationStartTime());
    }

    @Override
    public String toString() {
        return ToString.builder("ActiveViolation").add("ViolationId", violationId()).add("ThingName", thingName())
                .add("SecurityProfileName", securityProfileName()).add("Behavior", behavior())
                .add("LastViolationValue", lastViolationValue()).add("LastViolationTime", lastViolationTime())
                .add("ViolationStartTime", violationStartTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "violationId":
            return Optional.ofNullable(clazz.cast(violationId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "behavior":
            return Optional.ofNullable(clazz.cast(behavior()));
        case "lastViolationValue":
            return Optional.ofNullable(clazz.cast(lastViolationValue()));
        case "lastViolationTime":
            return Optional.ofNullable(clazz.cast(lastViolationTime()));
        case "violationStartTime":
            return Optional.ofNullable(clazz.cast(violationStartTime()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActiveViolationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ActiveViolation> {
        /**
         * <p>
         * The ID of the active violation.
         * </p>
         * 
         * @param violationId
         *        The ID of the active violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationId(String violationId);

        /**
         * <p>
         * The name of the thing responsible for the active violation.
         * </p>
         * 
         * @param thingName
         *        The name of the thing responsible for the active violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The security profile whose behavior is in violation.
         * </p>
         * 
         * @param securityProfileName
         *        The security profile whose behavior is in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The behavior which is being violated.
         * </p>
         * 
         * @param behavior
         *        The behavior which is being violated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behavior(Behavior behavior);

        /**
         * <p>
         * The behavior which is being violated.
         * </p>
         * This is a convenience that creates an instance of the {@link Behavior.Builder} avoiding the need to create
         * one manually via {@link Behavior#builder()}.
         *
         * When the {@link Consumer} completes, {@link Behavior.Builder#build()} is called immediately and its result is
         * passed to {@link #behavior(Behavior)}.
         * 
         * @param behavior
         *        a consumer that will call methods on {@link Behavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behavior(Behavior)
         */
        default Builder behavior(Consumer<Behavior.Builder> behavior) {
            return behavior(Behavior.builder().applyMutation(behavior).build());
        }

        /**
         * <p>
         * The value of the metric (the measurement) which caused the most recent violation.
         * </p>
         * 
         * @param lastViolationValue
         *        The value of the metric (the measurement) which caused the most recent violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastViolationValue(MetricValue lastViolationValue);

        /**
         * <p>
         * The value of the metric (the measurement) which caused the most recent violation.
         * </p>
         * This is a convenience that creates an instance of the {@link MetricValue.Builder} avoiding the need to create
         * one manually via {@link MetricValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricValue.Builder#build()} is called immediately and its result
         * is passed to {@link #lastViolationValue(MetricValue)}.
         * 
         * @param lastViolationValue
         *        a consumer that will call methods on {@link MetricValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastViolationValue(MetricValue)
         */
        default Builder lastViolationValue(Consumer<MetricValue.Builder> lastViolationValue) {
            return lastViolationValue(MetricValue.builder().applyMutation(lastViolationValue).build());
        }

        /**
         * <p>
         * The time the most recent violation occurred.
         * </p>
         * 
         * @param lastViolationTime
         *        The time the most recent violation occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastViolationTime(Instant lastViolationTime);

        /**
         * <p>
         * The time the violation started.
         * </p>
         * 
         * @param violationStartTime
         *        The time the violation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationStartTime(Instant violationStartTime);
    }

    static final class BuilderImpl implements Builder {
        private String violationId;

        private String thingName;

        private String securityProfileName;

        private Behavior behavior;

        private MetricValue lastViolationValue;

        private Instant lastViolationTime;

        private Instant violationStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveViolation model) {
            violationId(model.violationId);
            thingName(model.thingName);
            securityProfileName(model.securityProfileName);
            behavior(model.behavior);
            lastViolationValue(model.lastViolationValue);
            lastViolationTime(model.lastViolationTime);
            violationStartTime(model.violationStartTime);
        }

        public final String getViolationId() {
            return violationId;
        }

        @Override
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final Behavior.Builder getBehavior() {
            return behavior != null ? behavior.toBuilder() : null;
        }

        @Override
        public final Builder behavior(Behavior behavior) {
            this.behavior = behavior;
            return this;
        }

        public final void setBehavior(Behavior.BuilderImpl behavior) {
            this.behavior = behavior != null ? behavior.build() : null;
        }

        public final MetricValue.Builder getLastViolationValue() {
            return lastViolationValue != null ? lastViolationValue.toBuilder() : null;
        }

        @Override
        public final Builder lastViolationValue(MetricValue lastViolationValue) {
            this.lastViolationValue = lastViolationValue;
            return this;
        }

        public final void setLastViolationValue(MetricValue.BuilderImpl lastViolationValue) {
            this.lastViolationValue = lastViolationValue != null ? lastViolationValue.build() : null;
        }

        public final Instant getLastViolationTime() {
            return lastViolationTime;
        }

        @Override
        public final Builder lastViolationTime(Instant lastViolationTime) {
            this.lastViolationTime = lastViolationTime;
            return this;
        }

        public final void setLastViolationTime(Instant lastViolationTime) {
            this.lastViolationTime = lastViolationTime;
        }

        public final Instant getViolationStartTime() {
            return violationStartTime;
        }

        @Override
        public final Builder violationStartTime(Instant violationStartTime) {
            this.violationStartTime = violationStartTime;
            return this;
        }

        public final void setViolationStartTime(Instant violationStartTime) {
            this.violationStartTime = violationStartTime;
        }

        @Override
        public ActiveViolation build() {
            return new ActiveViolation(this);
        }
    }
}
