/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.AlertTargetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the alert target ARN and the role ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlertTarget implements StructuredPojo, ToCopyableBuilder<AlertTarget.Builder, AlertTarget> {
    private final String alertTargetArn;

    private final String roleArn;

    private AlertTarget(BuilderImpl builder) {
        this.alertTargetArn = builder.alertTargetArn;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The ARN of the notification target to which alerts are sent.
     * </p>
     * 
     * @return The ARN of the notification target to which alerts are sent.
     */
    public String alertTargetArn() {
        return alertTargetArn;
    }

    /**
     * <p>
     * The ARN of the role that grants permission to send alerts to the notification target.
     * </p>
     * 
     * @return The ARN of the role that grants permission to send alerts to the notification target.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alertTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlertTarget)) {
            return false;
        }
        AlertTarget other = (AlertTarget) obj;
        return Objects.equals(alertTargetArn(), other.alertTargetArn()) && Objects.equals(roleArn(), other.roleArn());
    }

    @Override
    public String toString() {
        return ToString.builder("AlertTarget").add("AlertTargetArn", alertTargetArn()).add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alertTargetArn":
            return Optional.ofNullable(clazz.cast(alertTargetArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlertTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AlertTarget> {
        /**
         * <p>
         * The ARN of the notification target to which alerts are sent.
         * </p>
         * 
         * @param alertTargetArn
         *        The ARN of the notification target to which alerts are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargetArn(String alertTargetArn);

        /**
         * <p>
         * The ARN of the role that grants permission to send alerts to the notification target.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants permission to send alerts to the notification target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String alertTargetArn;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AlertTarget model) {
            alertTargetArn(model.alertTargetArn);
            roleArn(model.roleArn);
        }

        public final String getAlertTargetArn() {
            return alertTargetArn;
        }

        @Override
        public final Builder alertTargetArn(String alertTargetArn) {
            this.alertTargetArn = alertTargetArn;
            return this;
        }

        public final void setAlertTargetArn(String alertTargetArn) {
            this.alertTargetArn = alertTargetArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public AlertTarget build() {
            return new AlertTarget(this);
        }
    }
}
