/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateTargetsWithJobRequest extends IotRequest implements
        ToCopyableBuilder<AssociateTargetsWithJobRequest.Builder, AssociateTargetsWithJobRequest> {
    private final List<String> targets;

    private final String jobId;

    private final String comment;

    private AssociateTargetsWithJobRequest(BuilderImpl builder) {
        super(builder);
        this.targets = builder.targets;
        this.jobId = builder.jobId;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * A list of thing group ARNs that define the targets of the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of thing group ARNs that define the targets of the job.
     */
    public List<String> targets() {
        return targets;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to this job when it was created.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * An optional comment string describing why the job was associated with the targets.
     * </p>
     * 
     * @return An optional comment string describing why the job was associated with the targets.
     */
    public String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTargetsWithJobRequest)) {
            return false;
        }
        AssociateTargetsWithJobRequest other = (AssociateTargetsWithJobRequest) obj;
        return Objects.equals(targets(), other.targets()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(comment(), other.comment());
    }

    @Override
    public String toString() {
        return ToString.builder("AssociateTargetsWithJobRequest").add("Targets", targets()).add("JobId", jobId())
                .add("Comment", comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, AssociateTargetsWithJobRequest> {
        /**
         * <p>
         * A list of thing group ARNs that define the targets of the job.
         * </p>
         * 
         * @param targets
         *        A list of thing group ARNs that define the targets of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * A list of thing group ARNs that define the targets of the job.
         * </p>
         * 
         * @param targets
         *        A list of thing group ARNs that define the targets of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);

        /**
         * <p>
         * The unique identifier you assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * An optional comment string describing why the job was associated with the targets.
         * </p>
         * 
         * @param comment
         *        An optional comment string describing why the job was associated with the targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private String jobId;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTargetsWithJobRequest model) {
            super(model);
            targets(model.targets);
            jobId(model.jobId);
            comment(model.comment);
        }

        public final Collection<String> getTargets() {
            return targets;
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateTargetsWithJobRequest build() {
            return new AssociateTargetsWithJobRequest(this);
        }
    }
}
