/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the AttachPrincipalPolicy operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachPrincipalPolicyRequest extends IotRequest implements
        ToCopyableBuilder<AttachPrincipalPolicyRequest.Builder, AttachPrincipalPolicyRequest> {
    private final String policyName;

    private final String principal;

    private AttachPrincipalPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.principal = builder.principal;
    }

    /**
     * <p>
     * The policy name.
     * </p>
     * 
     * @return The policy name.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon
     * Cognito ID.
     * </p>
     * 
     * @return The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an
     *         Amazon Cognito ID.
     */
    public String principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachPrincipalPolicyRequest)) {
            return false;
        }
        AttachPrincipalPolicyRequest other = (AttachPrincipalPolicyRequest) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(principal(), other.principal());
    }

    @Override
    public String toString() {
        return ToString.builder("AttachPrincipalPolicyRequest").add("PolicyName", policyName()).add("Principal", principal())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, AttachPrincipalPolicyRequest> {
        /**
         * <p>
         * The policy name.
         * </p>
         * 
         * @param policyName
         *        The policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon
         * Cognito ID.
         * </p>
         * 
         * @param principal
         *        The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an
         *        Amazon Cognito ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String policyName;

        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachPrincipalPolicyRequest model) {
            super(model);
            policyName(model.policyName);
            principal(model.principal);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachPrincipalPolicyRequest build() {
            return new AttachPrincipalPolicyRequest(this);
        }
    }
}
