/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.transform.AttributePayloadMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attribute payload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributePayload implements StructuredPojo, ToCopyableBuilder<AttributePayload.Builder, AttributePayload> {
    private final Map<String, String> attributes;

    private final Boolean merge;

    private AttributePayload(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.merge = builder.merge;
    }

    /**
     * <p>
     * A JSON string containing up to three key-value pair in JSON format. For example:
     * </p>
     * <p>
     * <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A JSON string containing up to three key-value pair in JSON format. For example:</p>
     *         <p>
     *         <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with the
     * attributes stored in the registry, instead of overwriting them.
     * </p>
     * <p>
     * To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.
     * </p>
     * <note>
     * <p>
     * The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code>.
     * </p>
     * </note>
     * 
     * @return Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with the
     *         attributes stored in the registry, instead of overwriting them.</p>
     *         <p>
     *         To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code>.
     *         </p>
     */
    public Boolean merge() {
        return merge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(merge());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributePayload)) {
            return false;
        }
        AttributePayload other = (AttributePayload) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(merge(), other.merge());
    }

    @Override
    public String toString() {
        return ToString.builder("AttributePayload").add("Attributes", attributes()).add("Merge", merge()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "merge":
            return Optional.ofNullable(clazz.cast(merge()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributePayloadMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AttributePayload> {
        /**
         * <p>
         * A JSON string containing up to three key-value pair in JSON format. For example:
         * </p>
         * <p>
         * <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
         * </p>
         * 
         * @param attributes
         *        A JSON string containing up to three key-value pair in JSON format. For example:</p>
         *        <p>
         *        <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with the
         * attributes stored in the registry, instead of overwriting them.
         * </p>
         * <p>
         * To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.
         * </p>
         * <note>
         * <p>
         * The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code>.
         * </p>
         * </note>
         * 
         * @param merge
         *        Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with
         *        the attributes stored in the registry, instead of overwriting them.</p>
         *        <p>
         *        To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder merge(Boolean merge);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Boolean merge;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributePayload model) {
            attributes(model.attributes);
            merge(model.merge);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Boolean getMerge() {
            return merge;
        }

        @Override
        public final Builder merge(Boolean merge) {
            this.merge = merge;
            return this;
        }

        public final void setMerge(Boolean merge) {
            this.merge = merge;
        }

        @Override
        public AttributePayload build() {
            return new AttributePayload(this);
        }
    }
}
