/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.AuditNotificationTargetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the targets to which audit notifications are sent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditNotificationTarget implements StructuredPojo,
        ToCopyableBuilder<AuditNotificationTarget.Builder, AuditNotificationTarget> {
    private final String targetArn;

    private final String roleArn;

    private final Boolean enabled;

    private AuditNotificationTarget(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The ARN of the target (SNS topic) to which audit notifications are sent.
     * </p>
     * 
     * @return The ARN of the target (SNS topic) to which audit notifications are sent.
     */
    public String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The ARN of the role that grants permission to send notifications to the target.
     * </p>
     * 
     * @return The ARN of the role that grants permission to send notifications to the target.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * True if notifications to the target are enabled.
     * </p>
     * 
     * @return True if notifications to the target are enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditNotificationTarget)) {
            return false;
        }
        AuditNotificationTarget other = (AuditNotificationTarget) obj;
        return Objects.equals(targetArn(), other.targetArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(enabled(), other.enabled());
    }

    @Override
    public String toString() {
        return ToString.builder("AuditNotificationTarget").add("TargetArn", targetArn()).add("RoleArn", roleArn())
                .add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuditNotificationTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AuditNotificationTarget> {
        /**
         * <p>
         * The ARN of the target (SNS topic) to which audit notifications are sent.
         * </p>
         * 
         * @param targetArn
         *        The ARN of the target (SNS topic) to which audit notifications are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The ARN of the role that grants permission to send notifications to the target.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants permission to send notifications to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * True if notifications to the target are enabled.
         * </p>
         * 
         * @param enabled
         *        True if notifications to the target are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String targetArn;

        private String roleArn;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditNotificationTarget model) {
            targetArn(model.targetArn);
            roleArn(model.roleArn);
            enabled(model.enabled);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public AuditNotificationTarget build() {
            return new AuditNotificationTarget(this);
        }
    }
}
