/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.transform.AuthInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of authorization information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthInfo implements StructuredPojo, ToCopyableBuilder<AuthInfo.Builder, AuthInfo> {
    private final String actionType;

    private final List<String> resources;

    private AuthInfo(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.resources = builder.resources;
    }

    /**
     * <p>
     * The type of action for which the principal is being authorized.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action for which the principal is being authorized.
     * @see ActionType
     */
    public ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of action for which the principal is being authorized.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action for which the principal is being authorized.
     * @see ActionType
     */
    public String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The resources for which the principal is being authorized to perform the specified action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The resources for which the principal is being authorized to perform the specified action.
     */
    public List<String> resources() {
        return resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resources());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthInfo)) {
            return false;
        }
        AuthInfo other = (AuthInfo) obj;
        return Objects.equals(actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(resources(), other.resources());
    }

    @Override
    public String toString() {
        return ToString.builder("AuthInfo").add("ActionType", actionTypeAsString()).add("Resources", resources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AuthInfo> {
        /**
         * <p>
         * The type of action for which the principal is being authorized.
         * </p>
         * 
         * @param actionType
         *        The type of action for which the principal is being authorized.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of action for which the principal is being authorized.
         * </p>
         * 
         * @param actionType
         *        The type of action for which the principal is being authorized.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * The resources for which the principal is being authorized to perform the specified action.
         * </p>
         * 
         * @param resources
         *        The resources for which the principal is being authorized to perform the specified action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<String> resources);

        /**
         * <p>
         * The resources for which the principal is being authorized to perform the specified action.
         * </p>
         * 
         * @param resources
         *        The resources for which the principal is being authorized to perform the specified action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(String... resources);
    }

    static final class BuilderImpl implements Builder {
        private String actionType;

        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthInfo model) {
            actionType(model.actionType);
            resources(model.resources);
        }

        public final String getActionType() {
            return actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final Collection<String> getResources() {
            return resources;
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
        }

        @Override
        public AuthInfo build() {
            return new AuthInfo(this);
        }
    }
}
