/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.AuthorizerSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authorizer summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizerSummary implements StructuredPojo, ToCopyableBuilder<AuthorizerSummary.Builder, AuthorizerSummary> {
    private final String authorizerName;

    private final String authorizerArn;

    private AuthorizerSummary(BuilderImpl builder) {
        this.authorizerName = builder.authorizerName;
        this.authorizerArn = builder.authorizerArn;
    }

    /**
     * <p>
     * The authorizer name.
     * </p>
     * 
     * @return The authorizer name.
     */
    public String authorizerName() {
        return authorizerName;
    }

    /**
     * <p>
     * The authorizer ARN.
     * </p>
     * 
     * @return The authorizer ARN.
     */
    public String authorizerArn() {
        return authorizerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizerSummary)) {
            return false;
        }
        AuthorizerSummary other = (AuthorizerSummary) obj;
        return Objects.equals(authorizerName(), other.authorizerName()) && Objects.equals(authorizerArn(), other.authorizerArn());
    }

    @Override
    public String toString() {
        return ToString.builder("AuthorizerSummary").add("AuthorizerName", authorizerName())
                .add("AuthorizerArn", authorizerArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizerName":
            return Optional.ofNullable(clazz.cast(authorizerName()));
        case "authorizerArn":
            return Optional.ofNullable(clazz.cast(authorizerArn()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthorizerSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AuthorizerSummary> {
        /**
         * <p>
         * The authorizer name.
         * </p>
         * 
         * @param authorizerName
         *        The authorizer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerName(String authorizerName);

        /**
         * <p>
         * The authorizer ARN.
         * </p>
         * 
         * @param authorizerArn
         *        The authorizer ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerArn(String authorizerArn);
    }

    static final class BuilderImpl implements Builder {
        private String authorizerName;

        private String authorizerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizerSummary model) {
            authorizerName(model.authorizerName);
            authorizerArn(model.authorizerArn);
        }

        public final String getAuthorizerName() {
            return authorizerName;
        }

        @Override
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        public final String getAuthorizerArn() {
            return authorizerArn;
        }

        @Override
        public final Builder authorizerArn(String authorizerArn) {
            this.authorizerArn = authorizerArn;
            return this;
        }

        public final void setAuthorizerArn(String authorizerArn) {
            this.authorizerArn = authorizerArn;
        }

        @Override
        public AuthorizerSummary build() {
            return new AuthorizerSummary(this);
        }
    }
}
