/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.BehaviorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Device Defender security profile behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Behavior implements StructuredPojo, ToCopyableBuilder<Behavior.Builder, Behavior> {
    private final String name;

    private final String metric;

    private final BehaviorCriteria criteria;

    private Behavior(BuilderImpl builder) {
        this.name = builder.name;
        this.metric = builder.metric;
        this.criteria = builder.criteria;
    }

    /**
     * <p>
     * The name you have given to the behavior.
     * </p>
     * 
     * @return The name you have given to the behavior.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * What is measured by the behavior.
     * </p>
     * 
     * @return What is measured by the behavior.
     */
    public String metric() {
        return metric;
    }

    /**
     * <p>
     * The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.
     * </p>
     * 
     * @return The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.
     */
    public BehaviorCriteria criteria() {
        return criteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(criteria());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Behavior)) {
            return false;
        }
        Behavior other = (Behavior) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(metric(), other.metric())
                && Objects.equals(criteria(), other.criteria());
    }

    @Override
    public String toString() {
        return ToString.builder("Behavior").add("Name", name()).add("Metric", metric()).add("Criteria", criteria()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "criteria":
            return Optional.ofNullable(clazz.cast(criteria()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BehaviorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Behavior> {
        /**
         * <p>
         * The name you have given to the behavior.
         * </p>
         * 
         * @param name
         *        The name you have given to the behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * What is measured by the behavior.
         * </p>
         * 
         * @param metric
         *        What is measured by the behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(String metric);

        /**
         * <p>
         * The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.
         * </p>
         * 
         * @param criteria
         *        The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(BehaviorCriteria criteria);

        /**
         * <p>
         * The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link BehaviorCriteria.Builder} avoiding the need to
         * create one manually via {@link BehaviorCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link BehaviorCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #criteria(BehaviorCriteria)}.
         * 
         * @param criteria
         *        a consumer that will call methods on {@link BehaviorCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criteria(BehaviorCriteria)
         */
        default Builder criteria(Consumer<BehaviorCriteria.Builder> criteria) {
            return criteria(BehaviorCriteria.builder().applyMutation(criteria).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String metric;

        private BehaviorCriteria criteria;

        private BuilderImpl() {
        }

        private BuilderImpl(Behavior model) {
            name(model.name);
            metric(model.metric);
            criteria(model.criteria);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetric() {
            return metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        public final BehaviorCriteria.Builder getCriteria() {
            return criteria != null ? criteria.toBuilder() : null;
        }

        @Override
        public final Builder criteria(BehaviorCriteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final void setCriteria(BehaviorCriteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public Behavior build() {
            return new Behavior(this);
        }
    }
}
