/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelJobRequest extends IotRequest implements ToCopyableBuilder<CancelJobRequest.Builder, CancelJobRequest> {
    private final String jobId;

    private final String comment;

    private final Boolean force;

    private CancelJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.comment = builder.comment;
        this.force = builder.force;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to this job when it was created.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * An optional comment string describing why the job was canceled.
     * </p>
     * 
     * @return An optional comment string describing why the job was canceled.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * (Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise
     * only job executions with status "QUEUED" are canceled. The default is <code>false</code>.
     * </p>
     * <p>
     * Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the
     * job execution status. Use caution and ensure that each device executing a job which is canceled is able to
     * recover to a valid state.
     * </p>
     * 
     * @return (Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled,
     *         otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p>
     *         <p>
     *         Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to
     *         update the job execution status. Use caution and ensure that each device executing a job which is
     *         canceled is able to recover to a valid state.
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelJobRequest)) {
            return false;
        }
        CancelJobRequest other = (CancelJobRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(comment(), other.comment())
                && Objects.equals(force(), other.force());
    }

    @Override
    public String toString() {
        return ToString.builder("CancelJobRequest").add("JobId", jobId()).add("Comment", comment()).add("Force", force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, CancelJobRequest> {
        /**
         * <p>
         * The unique identifier you assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * An optional comment string describing why the job was canceled.
         * </p>
         * 
         * @param comment
         *        An optional comment string describing why the job was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * (Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise
         * only job executions with status "QUEUED" are canceled. The default is <code>false</code>.
         * </p>
         * <p>
         * Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update
         * the job execution status. Use caution and ensure that each device executing a job which is canceled is able
         * to recover to a valid state.
         * </p>
         * 
         * @param force
         *        (Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled,
         *        otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>
         *        .</p>
         *        <p>
         *        Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to
         *        update the job execution status. Use caution and ensure that each device executing a job which is
         *        canceled is able to recover to a valid state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String jobId;

        private String comment;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelJobRequest model) {
            super(model);
            jobId(model.jobId);
            comment(model.comment);
            force(model.force);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelJobRequest build() {
            return new CancelJobRequest(this);
        }
    }
}
