/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CloudwatchMetricActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action that captures a CloudWatch metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudwatchMetricAction implements StructuredPojo,
        ToCopyableBuilder<CloudwatchMetricAction.Builder, CloudwatchMetricAction> {
    private final String roleArn;

    private final String metricNamespace;

    private final String metricName;

    private final String metricValue;

    private final String metricUnit;

    private final String metricTimestamp;

    private CloudwatchMetricAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.metricNamespace = builder.metricNamespace;
        this.metricName = builder.metricName;
        this.metricValue = builder.metricValue;
        this.metricUnit = builder.metricUnit;
        this.metricTimestamp = builder.metricTimestamp;
    }

    /**
     * <p>
     * The IAM role that allows access to the CloudWatch metric.
     * </p>
     * 
     * @return The IAM role that allows access to the CloudWatch metric.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The CloudWatch metric namespace name.
     * </p>
     * 
     * @return The CloudWatch metric namespace name.
     */
    public String metricNamespace() {
        return metricNamespace;
    }

    /**
     * <p>
     * The CloudWatch metric name.
     * </p>
     * 
     * @return The CloudWatch metric name.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The CloudWatch metric value.
     * </p>
     * 
     * @return The CloudWatch metric value.
     */
    public String metricValue() {
        return metricValue;
    }

    /**
     * <p>
     * The <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric
     * unit</a> supported by CloudWatch.
     * </p>
     * 
     * @return The <a
     *         href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit"
     *         >metric unit</a> supported by CloudWatch.
     */
    public String metricUnit() {
        return metricUnit;
    }

    /**
     * <p>
     * An optional <a href=
     * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix
     * timestamp</a>.
     * </p>
     * 
     * @return An optional <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp"
     *         >Unix timestamp</a>.
     */
    public String metricTimestamp() {
        return metricTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(metricUnit());
        hashCode = 31 * hashCode + Objects.hashCode(metricTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchMetricAction)) {
            return false;
        }
        CloudwatchMetricAction other = (CloudwatchMetricAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(metricNamespace(), other.metricNamespace())
                && Objects.equals(metricName(), other.metricName()) && Objects.equals(metricValue(), other.metricValue())
                && Objects.equals(metricUnit(), other.metricUnit()) && Objects.equals(metricTimestamp(), other.metricTimestamp());
    }

    @Override
    public String toString() {
        return ToString.builder("CloudwatchMetricAction").add("RoleArn", roleArn()).add("MetricNamespace", metricNamespace())
                .add("MetricName", metricName()).add("MetricValue", metricValue()).add("MetricUnit", metricUnit())
                .add("MetricTimestamp", metricTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "metricNamespace":
            return Optional.ofNullable(clazz.cast(metricNamespace()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "metricValue":
            return Optional.ofNullable(clazz.cast(metricValue()));
        case "metricUnit":
            return Optional.ofNullable(clazz.cast(metricUnit()));
        case "metricTimestamp":
            return Optional.ofNullable(clazz.cast(metricTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudwatchMetricActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CloudwatchMetricAction> {
        /**
         * <p>
         * The IAM role that allows access to the CloudWatch metric.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that allows access to the CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The CloudWatch metric namespace name.
         * </p>
         * 
         * @param metricNamespace
         *        The CloudWatch metric namespace name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamespace(String metricNamespace);

        /**
         * <p>
         * The CloudWatch metric name.
         * </p>
         * 
         * @param metricName
         *        The CloudWatch metric name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The CloudWatch metric value.
         * </p>
         * 
         * @param metricValue
         *        The CloudWatch metric value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValue(String metricValue);

        /**
         * <p>
         * The <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric
         * unit</a> supported by CloudWatch.
         * </p>
         * 
         * @param metricUnit
         *        The <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit"
         *        >metric unit</a> supported by CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricUnit(String metricUnit);

        /**
         * <p>
         * An optional <a href=
         * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp"
         * >Unix timestamp</a>.
         * </p>
         * 
         * @param metricTimestamp
         *        An optional <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp"
         *        >Unix timestamp</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTimestamp(String metricTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String metricNamespace;

        private String metricName;

        private String metricValue;

        private String metricUnit;

        private String metricTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchMetricAction model) {
            roleArn(model.roleArn);
            metricNamespace(model.metricNamespace);
            metricName(model.metricName);
            metricValue(model.metricValue);
            metricUnit(model.metricUnit);
            metricTimestamp(model.metricTimestamp);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getMetricNamespace() {
            return metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricValue() {
            return metricValue;
        }

        @Override
        public final Builder metricValue(String metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(String metricValue) {
            this.metricValue = metricValue;
        }

        public final String getMetricUnit() {
            return metricUnit;
        }

        @Override
        public final Builder metricUnit(String metricUnit) {
            this.metricUnit = metricUnit;
            return this;
        }

        public final void setMetricUnit(String metricUnit) {
            this.metricUnit = metricUnit;
        }

        public final String getMetricTimestamp() {
            return metricTimestamp;
        }

        @Override
        public final Builder metricTimestamp(String metricTimestamp) {
            this.metricTimestamp = metricTimestamp;
            return this;
        }

        public final void setMetricTimestamp(String metricTimestamp) {
            this.metricTimestamp = metricTimestamp;
        }

        @Override
        public CloudwatchMetricAction build() {
            return new CloudwatchMetricAction(this);
        }
    }
}
